/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFluids;

public class UGCaveWorldCarver
extends CaveWorldCarver {
    public UGCaveWorldCarver(Codec<CaveCarverConfiguration> configCodec) {
        super(configCodec);
        this.f_64983_ = ImmutableSet.of((Object)((Block)UGBlocks.DEPTHROCK.get()), (Object)((Block)UGBlocks.SHIVERSTONE.get()), (Object)((Block)UGBlocks.DEEPTURF_BLOCK.get()), (Object)((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get()), (Object)((Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()), (Object)((Block)UGBlocks.DEEPSOIL.get()), (Object[])new Block[]{(Block)UGBlocks.DEPTHROCK_COAL_ORE.get(), (Block)UGBlocks.DEPTHROCK_IRON_ORE.get(), (Block)UGBlocks.DEPTHROCK_GOLD_ORE.get(), (Block)UGBlocks.DEPTHROCK_DIAMOND_ORE.get(), (Block)UGBlocks.DEPTHROCK_CLOGGRUM_ORE.get(), (Block)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE.get(), (Block)UGBlocks.DEPTHROCK_UTHERIUM_ORE.get(), (Block)UGBlocks.DEPTHROCK_REGALIUM_ORE.get(), (Block)UGBlocks.SEDIMENT.get(), (Block)UGBlocks.COARSE_DEEPSOIL.get()});
        this.f_64984_ = ImmutableSet.of((Object)Fluids.f_76193_);
    }

    protected float m_5710_(Random random) {
        return super.m_5710_(random) * 3.0f;
    }

    protected boolean carveEllipsoid(CarvingContext pContext, CaveCarverConfiguration pConfig, ChunkAccess pChunk, Function<BlockPos, Holder<Biome>> pBiomeAccessor, Aquifer pAquifer, double pX, double pY, double pZ, double pHorizontalRadius, double pVerticalRadius, CarvingMask pCarvingMask, WorldCarver.CarveSkipChecker pSkipChecker) {
        ChunkPos chunkPos = pChunk.m_7697_();
        double middleX = chunkPos.m_151390_();
        double middleZ = chunkPos.m_151393_();
        double d2 = 16.0 + pHorizontalRadius * 2.0;
        if (!(Math.abs(pX - middleX) > d2) && !(Math.abs(pZ - middleZ) > d2)) {
            int i2;
            int l1;
            int minX = chunkPos.m_45604_();
            int minZ = chunkPos.m_45605_();
            int k = Math.max(Mth.m_14107_((double)(pX - pHorizontalRadius)) - minX - 1, 0);
            int l = Math.min(Mth.m_14107_((double)(pX + pHorizontalRadius)) - minX, 15);
            int i1 = Math.max(Mth.m_14107_((double)(pY - pVerticalRadius)) - 1, pContext.m_142201_() + 1);
            int j1 = pChunk.m_187679_() ? 0 : 7;
            int k1 = Math.min(Mth.m_14107_((double)(pY + pVerticalRadius)) + 1, pContext.m_142201_() + pContext.m_142208_() - 1 - j1);
            if (this.hasDisallowedLiquid(pChunk, k, l, i1, k1, l1 = Math.max(Mth.m_14107_((double)(pZ - pHorizontalRadius)) - minZ - 1, 0), i2 = Math.min(Mth.m_14107_((double)(pZ + pHorizontalRadius)) - minZ, 15))) {
                return false;
            }
            boolean flag = false;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (int j2 = k; j2 <= l; ++j2) {
                int k2 = chunkPos.m_151382_(j2);
                double d3 = ((double)k2 + 0.5 - pX) / pHorizontalRadius;
                for (int l2 = l1; l2 <= i2; ++l2) {
                    int i3 = chunkPos.m_151391_(l2);
                    double d4 = ((double)i3 + 0.5 - pZ) / pHorizontalRadius;
                    if (d3 * d3 + d4 * d4 >= 1.0) continue;
                    MutableBoolean mutableboolean = new MutableBoolean(false);
                    for (int j3 = k1; j3 > i1; --j3) {
                        double d5 = ((double)j3 - 0.5 - pY) / pVerticalRadius;
                        if (pSkipChecker.m_159425_(pContext, d3, d5, d4, j3) || pCarvingMask.m_187594_(j2, j3, l2)) continue;
                        pCarvingMask.m_187585_(j2, j3, l2);
                        blockpos$mutableblockpos.m_122178_(k2, j3, i3);
                        flag |= this.carveBlock(pContext, pConfig, pChunk, pBiomeAccessor, pCarvingMask, blockpos$mutableblockpos, blockpos$mutableblockpos1, pAquifer, mutableboolean);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected boolean carveBlock(CarvingContext context, CaveCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, CarvingMask carvingMask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean reachedSurface) {
        BlockState chunkState = chunk.m_8055_((BlockPos)pos);
        if (chunkState.m_60713_((Block)UGBlocks.DEEPTURF_BLOCK.get()) || chunkState.m_60713_((Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()) || chunkState.m_60713_((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get())) {
            reachedSurface.setTrue();
        }
        if (!this.m_65010_(chunkState)) {
            return false;
        }
        BlockState carveState = this.getCarveState(context, config, (BlockPos)pos);
        if (carveState == null) {
            return false;
        }
        chunk.m_6978_((BlockPos)pos, carveState, false);
        if (aquifer.m_142203_() && !carveState.m_60819_().m_76178_()) {
            chunk.m_8113_((BlockPos)pos);
        }
        if (reachedSurface.isTrue()) {
            checkPos.m_122159_((Vec3i)pos, Direction.DOWN);
            if (chunk.m_8055_((BlockPos)checkPos).m_60713_((Block)UGBlocks.DEEPSOIL.get())) {
                context.m_190646_(biomeAccessor, chunk, (BlockPos)checkPos, !carveState.m_60819_().m_76178_()).ifPresent(state -> {
                    chunk.m_6978_((BlockPos)checkPos, state, false);
                    if (!state.m_60819_().m_76178_()) {
                        chunk.m_8113_((BlockPos)checkPos);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private BlockState getCarveState(CarvingContext context, CaveCarverConfiguration config, BlockPos pos) {
        if (pos.m_123342_() <= config.f_159090_.m_142322_((WorldGenerationContext)context)) {
            return ((FlowingFluid)UGFluids.VIRULENT_MIX_SOURCE.get()).m_76145_().m_76188_();
        }
        return f_64980_;
    }

    protected boolean hasDisallowedLiquid(ChunkAccess chunk, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ChunkPos chunkpos = chunk.m_7697_();
        int minBlockX = chunkpos.m_45604_();
        int minBlockZ = chunkpos.m_45605_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY - 1; y <= maxY + 1; ++y) {
                    mutablePos.m_122178_(minBlockX + x, y, minBlockZ + z);
                    if (this.f_64984_.contains(chunk.m_6425_((BlockPos)mutablePos).m_76152_())) {
                        return true;
                    }
                    if (y == maxY + 1 || UGCaveWorldCarver.isEdge(x, z, minX, maxX, minZ, maxZ)) continue;
                    y = maxY;
                }
            }
        }
        return false;
    }

    private static boolean isEdge(int x, int z, int minX, int maxX, int minZ, int maxZ) {
        return x == minX || x == maxX || z == minZ || z == maxZ;
    }
}

