/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderData {
    private final ItemStack stack;
    private final Player player;
    private final FluidTank leftTank = this.createFluidHandler();
    private final FluidTank rightTank = this.createFluidHandler();
    private final String LEFT_TANK = "LeftTank";
    private final String RIGHT_TANK = "RightTank";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";

    public RenderData(Player player, ItemStack stack, boolean loadData) {
        this.player = player;
        this.stack = stack;
        if (loadData) {
            this.loadDataFromStack(stack);
        }
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getSleepingBagColor() {
        if (this.stack.m_41784_().m_128441_("SleepingBagColor")) {
            return this.stack.m_41784_().m_128451_("SleepingBagColor");
        }
        return DyeColor.RED.m_41060_();
    }

    public void loadDataFromStack(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41782_()) {
            this.loadTanks(stack.m_41784_());
        }
    }

    public void loadTanks(CompoundTag compound) {
        this.leftTank.readFromNBT(compound.m_128469_("LeftTank"));
        this.rightTank.readFromNBT(compound.m_128469_("RightTank"));
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(Tiers.LEATHER.getTankCapacity()){

            public FluidTank readFromNBT(CompoundTag nbt) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
                this.setCapacity(Tiers.of(RenderData.this.stack.m_41784_().m_128461_("Tier")).getTankCapacity());
                this.setFluid(fluid);
                return this;
            }
        };
    }
}

