/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;

public class AccessBackpackCommand {
    public AccessBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"access").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(source -> this.openTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.m_118242_((CommandContext)source, (String)"pos"))))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(source -> this.openTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int openTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.m_81372_().m_7702_(blockPos) instanceof TravelersBackpackBlockEntity) {
            NetworkHooks.openGui((ServerPlayer)source.m_81375_(), (MenuProvider)((TravelersBackpackBlockEntity)source.m_81372_().m_7702_(blockPos)), (BlockPos)blockPos);
            source.m_81354_((Component)new TextComponent("Accessing backpack of " + blockPos.m_123344_()), true);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("There's no backpack at coordinates " + blockPos.m_123344_()));
        return -1;
    }

    public int openTargetInventory(CommandSourceStack source, ServerPlayer serverPlayer) throws CommandSyntaxException {
        ServerPlayer self = source.m_81375_();
        boolean hasBackpack = CapabilityUtils.isWearingBackpack((Player)serverPlayer);
        if (hasBackpack) {
            NetworkHooks.openGui((ServerPlayer)self, (MenuProvider)CapabilityUtils.getBackpackInv((Player)serverPlayer), packetBuffer -> packetBuffer.writeByte(2).writeInt(serverPlayer.m_142049_()));
            source.m_81354_((Component)new TextComponent("Accessing backpack of " + serverPlayer.m_5446_().getString()), true);
            return 1;
        }
        source.m_81352_((Component)new TextComponent("Can't access backpack"));
        return -1;
    }
}

