/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RecipeUtils;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedBackpackRecipe
extends ShapedRecipe {
    public ShapedBackpackRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack output = super.m_5874_(inv);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (!ingredient.m_41619_() && ingredient.m_41720_() instanceof TravelersBackpackItem) {
                    CompoundTag compound = ingredient.m_41783_();
                    output.m_41751_(compound);
                    break;
                }
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof SleepingBagItem)) continue;
                output.m_41784_().m_128405_("SleepingBagColor", ShapedBackpackRecipe.getProperColor((SleepingBagItem)ingredient.m_41720_()));
            }
        }
        return output;
    }

    public static int getProperColor(SleepingBagItem item) {
        Block block = item.m_40614_();
        if (block instanceof SleepingBagBlock) {
            SleepingBagBlock sleepingBag = (SleepingBagBlock)block;
            return sleepingBag.m_49554_().m_41060_();
        }
        return DyeColor.RED.m_41060_();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapedBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ShapedBackpackRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            RecipeUtils.ShapedPrimer primer = RecipeUtils.parseShaped(json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapedBackpackRecipe(recipeID, group, primer.getRecipeWidth(), primer.getRecipeHeight(), primer.getIngredients(), result);
        }

        @Nullable
        public ShapedBackpackRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            return new ShapedBackpackRecipe(recipeID, group, width, height, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedBackpackRecipe recipe) {
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.m_8043_(), false);
        }
    }
}

