/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import com.tiviacz.travelersbackpack.datagen.ModRecipeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TravelersBackpackConfig {
    public static boolean enableTierUpgrades;
    public static boolean disableCrafting;
    public static boolean enableBackpackBlockWearable;
    public static boolean invulnerableBackpack;
    public static boolean toolSlotsAcceptSwords;
    public static List<? extends String> toolSlotsAcceptableItems;
    public static List<? extends String> blacklistedItems;
    public static boolean allowShulkerBoxes;
    public static List<? extends Integer> tanksCapacity;
    public static boolean voidProtection;
    public static boolean backpackDeathPlace;
    public static boolean backpackForceDeathPlace;
    public static boolean enableSleepingBagSpawnPoint;
    public static boolean curiosIntegration;
    public static boolean enableLoot;
    public static boolean spawnEntitiesWithBackpack;
    public static List<? extends String> possibleOverworldEntityTypes;
    public static List<? extends String> possibleNetherEntityTypes;
    public static int spawnChance;
    public static List<? extends String> overworldBackpacks;
    public static List<? extends String> netherBackpacks;
    public static boolean enableVillagerTrade;
    public static boolean enableBackpackAbilities;
    public static boolean forceAbilityEnabled;
    public static boolean tooManyBackpacksSlowness;
    public static int maxNumberOfBackpacks;
    public static double slownessPerExcessedBackpack;
    public static boolean enableToolCycling;
    public static boolean disableScrollWheel;
    public static boolean obtainTips;
    public static boolean renderTools;
    public static boolean renderBackpackWithElytra;
    public static boolean disableBackpackRender;
    public static boolean enableOverlay;
    public static int offsetX;
    public static int offsetY;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    private static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            TravelersBackpackConfig.bakeCommonConfig();
        }
        if (configEvent.getConfig().getSpec() == clientSpec) {
            TravelersBackpackConfig.bakeClientConfig();
        }
    }

    public static void bakeCommonConfig() {
        enableTierUpgrades = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableTierUpgrades.get();
        disableCrafting = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.disableCrafting.get();
        enableBackpackBlockWearable = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableBackpackBlockWearable.get();
        invulnerableBackpack = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.invulnerableBackpack.get();
        toolSlotsAcceptSwords = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.toolSlotsAcceptSwords.get();
        toolSlotsAcceptableItems = (List)TravelersBackpackConfig.COMMON.backpackSettings.toolSlotsAcceptableItems.get();
        blacklistedItems = (List)TravelersBackpackConfig.COMMON.backpackSettings.blacklistedItems.get();
        allowShulkerBoxes = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.allowShulkerBoxes.get();
        tanksCapacity = (List)TravelersBackpackConfig.COMMON.backpackSettings.tanksCapacity.get();
        voidProtection = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.voidProtection.get();
        backpackDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.backpackDeathPlace.get();
        backpackForceDeathPlace = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.backpackForceDeathPlace.get();
        enableSleepingBagSpawnPoint = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.enableSleepingBagSpawnPoint.get();
        curiosIntegration = (Boolean)TravelersBackpackConfig.COMMON.backpackSettings.curiosIntegration.get();
        enableLoot = (Boolean)TravelersBackpackConfig.COMMON.world.enableLoot.get();
        spawnEntitiesWithBackpack = (Boolean)TravelersBackpackConfig.COMMON.world.spawnEntitiesWithBackpack.get();
        possibleOverworldEntityTypes = (List)TravelersBackpackConfig.COMMON.world.possibleOverworldEntityTypes.get();
        possibleNetherEntityTypes = (List)TravelersBackpackConfig.COMMON.world.possibleNetherEntityTypes.get();
        spawnChance = (Integer)TravelersBackpackConfig.COMMON.world.spawnChance.get();
        overworldBackpacks = (List)TravelersBackpackConfig.COMMON.world.overworldBackpacks.get();
        netherBackpacks = (List)TravelersBackpackConfig.COMMON.world.netherBackpacks.get();
        enableVillagerTrade = (Boolean)TravelersBackpackConfig.COMMON.world.enableVillagerTrade.get();
        enableBackpackAbilities = (Boolean)TravelersBackpackConfig.COMMON.backpackAbilities.enableBackpackAbilities.get();
        forceAbilityEnabled = (Boolean)TravelersBackpackConfig.COMMON.backpackAbilities.forceAbilityEnabled.get();
        tooManyBackpacksSlowness = (Boolean)TravelersBackpackConfig.COMMON.slownessDebuff.tooManyBackpacksSlowness.get();
        maxNumberOfBackpacks = (Integer)TravelersBackpackConfig.COMMON.slownessDebuff.maxNumberOfBackpacks.get();
        slownessPerExcessedBackpack = (Double)TravelersBackpackConfig.COMMON.slownessDebuff.slownessPerExcessedBackpack.get();
    }

    public static void bakeClientConfig() {
        enableToolCycling = (Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get();
        disableScrollWheel = (Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get();
        obtainTips = (Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get();
        renderTools = (Boolean)TravelersBackpackConfig.CLIENT.renderTools.get();
        renderBackpackWithElytra = (Boolean)TravelersBackpackConfig.CLIENT.renderBackpackWithElytra.get();
        disableBackpackRender = (Boolean)TravelersBackpackConfig.CLIENT.disableBackpackRender.get();
        enableOverlay = (Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get();
        offsetX = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
        offsetY = (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new ModRecipeProvider(generator));
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        private static final String REGISTRY_NAME_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)";
        BackpackSettings backpackSettings;
        World world;
        BackpackAbilities backpackAbilities;
        SlownessDebuff slownessDebuff;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.backpackSettings = new BackpackSettings(builder, "backpackSettings");
            this.world = new World(builder, "world");
            this.backpackAbilities = new BackpackAbilities(builder, "backpackAbilities");
            this.slownessDebuff = new SlownessDebuff(builder, "slownessDebuff");
            builder.pop();
        }

        public void loadItemsFromConfig(List<? extends String> configList, List<Item> targetList) {
            for (String string : configList) {
                ResourceLocation res = new ResourceLocation(string);
                if (!ForgeRegistries.ITEMS.containsKey(res)) continue;
                targetList.add((Item)ForgeRegistries.ITEMS.getValue(res));
            }
        }

        public void loadEntityTypesFromConfig(List<? extends String> configList, List<EntityType> targetList) {
            for (String string : configList) {
                ResourceLocation res = new ResourceLocation(string);
                if (!ForgeRegistries.ENTITIES.containsKey(res)) continue;
                targetList.add((EntityType)ForgeRegistries.ENTITIES.getValue(res));
            }
        }

        public static class BackpackSettings {
            public final ForgeConfigSpec.BooleanValue enableTierUpgrades;
            public final ForgeConfigSpec.BooleanValue disableCrafting;
            public final ForgeConfigSpec.BooleanValue enableBackpackBlockWearable;
            public final ForgeConfigSpec.BooleanValue invulnerableBackpack;
            public final ForgeConfigSpec.BooleanValue toolSlotsAcceptSwords;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> toolSlotsAcceptableItems;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedItems;
            public final ForgeConfigSpec.BooleanValue allowShulkerBoxes;
            public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> tanksCapacity;
            public final ForgeConfigSpec.BooleanValue voidProtection;
            public final ForgeConfigSpec.BooleanValue backpackDeathPlace;
            public final ForgeConfigSpec.BooleanValue backpackForceDeathPlace;
            public final ForgeConfigSpec.BooleanValue enableSleepingBagSpawnPoint;
            public final ForgeConfigSpec.BooleanValue curiosIntegration;

            BackpackSettings(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableTierUpgrades = builder.define("enableTierUpgrades", true);
                this.disableCrafting = builder.define("disableCrafting", false);
                this.enableBackpackBlockWearable = builder.comment("Enables wearing backpack directly from ground").define("enableBackpackBlockWearable", true);
                this.invulnerableBackpack = builder.comment("Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item").define("invulnerableBackpack", true);
                this.toolSlotsAcceptSwords = builder.define("toolSlotsAcceptSwords", true);
                this.toolSlotsAcceptableItems = builder.comment("List of items that can be put in tool slots (Use registry names, for example: minecraft:apple)").defineList("toolSlotsAcceptableItems", Collections.emptyList(), mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.blacklistedItems = builder.comment("List of items that can't be put in backpack inventory (Use registry names, for example: minecraft:apple)").defineList("blacklistedItems", Collections.emptyList(), mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.allowShulkerBoxes = builder.define("allowShulkerBoxes", false);
                this.tanksCapacity = builder.comment("Represents tanks capacity for each tier, from left: Leather, Iron, Gold, Diamond, Netherite, 1000 equals 1 Bucket").defineList("tanksCapacity", this.getTanksCapacity(), mapping -> String.valueOf(mapping).matches("\\d+"));
                this.voidProtection = builder.comment("Prevents backpack disappearing in void").define("voidProtection", true);
                this.backpackDeathPlace = builder.comment("Places backpack at place where player died").define("backpackDeathPlace", true);
                this.backpackForceDeathPlace = builder.comment("Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)").define("backpackForceDeathPlace", false);
                this.enableSleepingBagSpawnPoint = builder.define("enableSleepingBagSpawnPoint", false);
                this.curiosIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in curios 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).define("curiosIntegration", false);
                builder.pop();
            }

            private List<Integer> getTanksCapacity() {
                ArrayList<Integer> ret = new ArrayList<Integer>();
                ret.add(2000);
                ret.add(3000);
                ret.add(4000);
                ret.add(5000);
                ret.add(6000);
                return ret;
            }
        }

        public static class World {
            public final ForgeConfigSpec.BooleanValue enableLoot;
            public final ForgeConfigSpec.BooleanValue spawnEntitiesWithBackpack;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> possibleOverworldEntityTypes;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> possibleNetherEntityTypes;
            public final ForgeConfigSpec.IntValue spawnChance;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> overworldBackpacks;
            public final ForgeConfigSpec.ConfigValue<List<? extends String>> netherBackpacks;
            public final ForgeConfigSpec.BooleanValue enableVillagerTrade;

            World(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").define("enableLoot", true);
                this.spawnEntitiesWithBackpack = builder.comment("Enables chance to spawn Zombie, Skeleton, Wither Skeleton, Piglin or Enderman with random backpack equipped").define("spawnEntitiesWithBackpack", true);
                this.possibleOverworldEntityTypes = builder.comment("List of overworld entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleOverworldEntityTypes", this::getPossibleOverworldEntityTypes, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.possibleNetherEntityTypes = builder.comment("List of nether entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleNetherEntityTypes", this::getPossibleNetherEntityTypes, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.spawnChance = builder.comment("Defines spawn chance of entity with backpack (1 in [selected value])").defineInRange("spawnChance", 500, 0, Integer.MAX_VALUE);
                this.overworldBackpacks = builder.comment("List of backpacks that can spawn on overworld mobs").defineList("overworldBackpacks", this::getOverworldBackpacksList, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.netherBackpacks = builder.comment("List of backpacks that can spawn on nether mobs").defineList("netherBackpacks", this::getNetherBackpacksList, mapping -> ((String)mapping).matches(Common.REGISTRY_NAME_MATCHER));
                this.enableVillagerTrade = builder.comment("Enables trade for Villager Backpack in Librarian villager trades").define("enableVillagerTrade", true);
                builder.pop();
            }

            private List<String> getPossibleOverworldEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:zombie");
                ret.add("minecraft:skeleton");
                ret.add("minecraft:enderman");
                return ret;
            }

            private List<String> getPossibleNetherEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:wither_skeleton");
                ret.add("minecraft:piglin");
                return ret;
            }

            private List<String> getOverworldBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:standard");
                ret.add("travelersbackpack:diamond");
                ret.add("travelersbackpack:gold");
                ret.add("travelersbackpack:emerald");
                ret.add("travelersbackpack:iron");
                ret.add("travelersbackpack:lapis");
                ret.add("travelersbackpack:redstone");
                ret.add("travelersbackpack:coal");
                ret.add("travelersbackpack:bookshelf");
                ret.add("travelersbackpack:sandstone");
                ret.add("travelersbackpack:snow");
                ret.add("travelersbackpack:sponge");
                ret.add("travelersbackpack:cake");
                ret.add("travelersbackpack:cactus");
                ret.add("travelersbackpack:hay");
                ret.add("travelersbackpack:melon");
                ret.add("travelersbackpack:pumpkin");
                ret.add("travelersbackpack:creeper");
                ret.add("travelersbackpack:enderman");
                ret.add("travelersbackpack:skeleton");
                ret.add("travelersbackpack:spider");
                ret.add("travelersbackpack:bee");
                ret.add("travelersbackpack:wolf");
                ret.add("travelersbackpack:fox");
                ret.add("travelersbackpack:ocelot");
                ret.add("travelersbackpack:horse");
                ret.add("travelersbackpack:cow");
                ret.add("travelersbackpack:pig");
                ret.add("travelersbackpack:sheep");
                ret.add("travelersbackpack:chicken");
                ret.add("travelersbackpack:squid");
                return ret;
            }

            private List<String> getNetherBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:quartz");
                ret.add("travelersbackpack:nether");
                ret.add("travelersbackpack:blaze");
                ret.add("travelersbackpack:ghast");
                ret.add("travelersbackpack:magma_cube");
                ret.add("travelersbackpack:wither");
                return ret;
            }
        }

        public static class BackpackAbilities {
            public final ForgeConfigSpec.BooleanValue enableBackpackAbilities;
            public final ForgeConfigSpec.BooleanValue forceAbilityEnabled;

            BackpackAbilities(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableBackpackAbilities = builder.define("enableBackpackAbilities", true);
                this.forceAbilityEnabled = builder.define("forceAbilityEnabled", false);
                builder.pop();
            }
        }

        public static class SlownessDebuff {
            public final ForgeConfigSpec.BooleanValue tooManyBackpacksSlowness;
            public final ForgeConfigSpec.IntValue maxNumberOfBackpacks;
            public final ForgeConfigSpec.DoubleValue slownessPerExcessedBackpack;

            SlownessDebuff(ForgeConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.tooManyBackpacksSlowness = builder.comment("Player gets slowness effect, if carries too many backpacks in inventory").define("tooManyBackpacksSlowness", false);
                this.maxNumberOfBackpacks = builder.comment("Maximum number of backpacks, which can be carried in inventory, without slowness effect").defineInRange("maxNumberOfBackpacks", 3, 1, 37);
                this.slownessPerExcessedBackpack = builder.defineInRange("slownessPerExcessedBackpack", 1.0, 0.1, 5.0);
                builder.pop();
            }
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue enableToolCycling;
        public final ForgeConfigSpec.BooleanValue disableScrollWheel;
        public final ForgeConfigSpec.BooleanValue obtainTips;
        public final ForgeConfigSpec.BooleanValue renderTools;
        public final ForgeConfigSpec.BooleanValue renderBackpackWithElytra;
        public final ForgeConfigSpec.BooleanValue disableBackpackRender;
        public final Overlay overlay;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.enableToolCycling = builder.comment("Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn").define("enableToolCycling", true);
            this.disableScrollWheel = builder.comment("Allows tool cycling using keybinding only (Default Z)").define("disableScrollWheel", false);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").define("renderTools", true);
            this.renderBackpackWithElytra = builder.comment("Render backpack if elytra is present").define("renderBackpackWithElytra", true);
            this.disableBackpackRender = builder.comment("Disable backpack rendering").define("disableBackpackRender", false);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ForgeConfigSpec.BooleanValue enableOverlay;
            public final ForgeConfigSpec.IntValue offsetX;
            public final ForgeConfigSpec.IntValue offsetY;

            Overlay(ForgeConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }
}

