/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundUpdateRecipePacket {
    public static final ResourceLocation NULL = new ResourceLocation("null", "null");
    private final ResourceLocation recipeId;
    private final ItemStack output;

    public ClientboundUpdateRecipePacket(Recipe recipe, ItemStack output) {
        this.recipeId = recipe == null ? NULL : recipe.m_6423_();
        this.output = output;
    }

    public ClientboundUpdateRecipePacket(ResourceLocation recipeId, ItemStack output) {
        this.recipeId = recipeId;
        this.output = output;
    }

    public static ClientboundUpdateRecipePacket decode(FriendlyByteBuf buffer) {
        ResourceLocation recipeId;
        return new ClientboundUpdateRecipePacket(recipeId, (recipeId = new ResourceLocation(buffer.m_130277_())).equals((Object)NULL) ? ItemStack.f_41583_ : buffer.m_130267_());
    }

    public static void encode(ClientboundUpdateRecipePacket message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.recipeId.toString());
        if (!message.recipeId.equals((Object)NULL)) {
            buffer.m_130055_(message.output);
        }
    }

    public static void handle(ClientboundUpdateRecipePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Recipe recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(message.recipeId).orElse(null);
            Screen patt2097$temp = Minecraft.m_91087_().f_91080_;
            if (patt2097$temp instanceof TravelersBackpackScreen) {
                TravelersBackpackScreen screen = (TravelersBackpackScreen)patt2097$temp;
                ((TravelersBackpackBaseMenu)screen.m_6262_()).resultSlots.m_6029_(recipe);
                ((TravelersBackpackBaseMenu)screen.m_6262_()).resultSlots.m_6836_(0, message.output);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

