/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Triple;

public class RenderUtils {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.29000002f;
    private static final float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.01f, 0.29000002f}}, new float[][]{{0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.29000002f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.29000002f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.01f, 0.29000002f}}, new float[][]{{0.135f, 0.01f, 0.29000002f}, {0.135f, 0.29000002f, 0.29000002f}, {0.135f, 0.29000002f, 0.135f}, {0.135f, 0.01f, 0.135f}}, new float[][]{{0.29000002f, 0.01f, 0.135f}, {0.29000002f, 0.29000002f, 0.135f}, {0.29000002f, 0.29000002f, 0.29000002f}, {0.29000002f, 0.01f, 0.29000002f}}};

    public static void renderScreenTank(PoseStack matrixStackIn, FluidTank tank, double x, double y, double height, double width) {
        RenderUtils.renderScreenTank(matrixStackIn, tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, height, width);
    }

    public static void renderScreenTank(PoseStack matrixStackIn, FluidStack fluid, int capacity, int amount, double x, double y, double height, double width) {
        if (fluid == null || fluid.getFluid() == null || amount <= 0) {
            return;
        }
        TextureAtlasSprite icon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluid.getFluid().getAttributes().getStillTexture());
        if (icon == null) {
            icon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int color = fluid.getFluid() == ModFluids.POTION_FLUID.get() ? fluid.getFluid().getAttributes().getColor(fluid) : fluid.getFluid().getAttributes().getColor();
        matrixStackIn.m_85836_();
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69461_();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.m_118409_();
                float minV = icon.m_118411_();
                float maxU = icon.m_118410_();
                float maxV = icon.m_118412_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder builder = tessellator.m_85915_();
                builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                builder.m_5483_((double)drawX, (double)(drawY + drawHeight), 0.0).m_7421_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                builder.m_5483_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                builder.m_5483_((double)(drawX + drawWidth), (double)drawY, 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).m_5752_();
                builder.m_5483_((double)drawX, (double)drawY, 0.0).m_7421_(minU, minV).m_5752_();
                tessellator.m_85914_();
            }
            i += 16;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStackIn.m_85849_();
    }

    public static void renderFluidSides(@Nullable ITravelersBackpackContainer inv, PoseStack matrixStackIn, MultiBufferSource buffer, float height, FluidStack fluid, int brightness) {
        Triple<Float, Float, Float> colorParts = RenderUtils.getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        for (Direction direction : Direction.values()) {
            TextureAtlasSprite icon = RenderUtils.getFluidIcon(inv, fluid, direction);
            VertexConsumer renderer = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_118414_().m_118330_()));
            float[][] c = coordinates[direction.ordinal()];
            float replacedMaxV = direction == Direction.UP || direction == Direction.DOWN ? icon.m_118393_(4.0) : (icon.m_118412_() - icon.m_118411_()) * height + icon.m_118411_();
            float replacedU1 = direction == Direction.UP || direction == Direction.DOWN ? icon.m_118367_(4.0) : icon.m_118367_(7.0);
            float replacedU2 = direction == Direction.UP || direction == Direction.DOWN ? icon.m_118367_(8.0) : icon.m_118367_(8.0);
            renderer.m_85982_(matrix4f, c[0][0], RenderUtils.getHeight(c[0][1], height), c[0][2]).m_85950_(r, g, b, a).m_7421_(replacedU1, replacedMaxV).m_85969_(brightness).m_5752_();
            renderer.m_85982_(matrix4f, c[1][0], RenderUtils.getHeight(c[1][1], height), c[1][2]).m_85950_(r, g, b, a).m_7421_(replacedU1, icon.m_118411_()).m_85969_(brightness).m_5752_();
            renderer.m_85982_(matrix4f, c[2][0], RenderUtils.getHeight(c[2][1], height), c[2][2]).m_85950_(r, g, b, a).m_7421_(replacedU2, icon.m_118411_()).m_85969_(brightness).m_5752_();
            renderer.m_85982_(matrix4f, c[3][0], RenderUtils.getHeight(c[3][1], height), c[3][2]).m_85950_(r, g, b, a).m_7421_(replacedU2, replacedMaxV).m_85969_(brightness).m_5752_();
        }
    }

    private static float getHeight(float height, float replaceHeight) {
        if (height == 0.29000002f) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(@Nullable ITravelersBackpackContainer inv, FluidTank tank, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLightIn, float x, float y, float z) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (!tank.isEmpty() && !tank.getFluid().isEmpty()) {
            matrixStackIn.m_85837_((double)x, (double)y, (double)z);
            float height = RenderUtils.getTankFillRatio(tank) * 0.99f;
            RenderUtils.renderFluidSides(inv, matrixStackIn, buffer, height, tank.getFluid(), combinedLightIn);
        }
        matrixStackIn.m_85849_();
    }

    public static TextureAtlasSprite getFluidIcon(@Nullable ITravelersBackpackContainer inv, FluidStack fluidstack, Direction direction) {
        TextureAtlasSprite icon;
        Block defaultBlock;
        Block block = defaultBlock = Blocks.f_49990_;
        if (fluidstack.getFluid().getAttributes().getBlock((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, inv == null ? BlockPos.f_121853_ : inv.getPosition(), fluidstack.getFluid().m_76145_()) != null) {
            block = fluidstack.getFluid().getAttributes().getBlock((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, inv == null ? BlockPos.f_121853_ : inv.getPosition(), fluidstack.getFluid().m_76145_()).m_60734_();
        }
        if (direction == null) {
            direction = Direction.UP;
        }
        if ((icon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidstack.getFluid().getAttributes().getFlowingTexture())) == null || direction == Direction.UP || direction == Direction.DOWN) {
            icon = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidstack.getFluid().getAttributes().getStillTexture());
        }
        if (icon == null && (icon = RenderUtils.getBlockIcon(block)) == null) {
            icon = RenderUtils.getBlockIcon(defaultBlock);
        }
        return icon;
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(block.m_49966_());
    }

    public static float getTankFillRatio(FluidTank tank) {
        return Math.min(1.0f, (float)tank.getFluidAmount() / (float)tank.getCapacity()) * 0.5f;
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(FluidStack fluidStack) {
        int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
        return RenderUtils.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

