/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;

public class CodecHelper {
    public static Codec<BlockState> BLOCKSTATE_STRING_CODEC = Codec.STRING.xmap(CodecHelper::blockStateFromString, StateHolder::toString);
    public static final Codec<Rotation> ROTATION_CODEC = Codec.STRING.comapFlatMap(CodecHelper::readRotation, CodecHelper::writeRotation);
    private static final BiMap<String, Rotation> rotationMap = HashBiMap.create();

    public static BlockState blockStateFromString(String blockStateString) {
        BlockState blockState;
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = blockStateString;
        int startIndex = blockStateString.indexOf(91);
        int stopIndex = blockStateString.indexOf(93);
        if (startIndex != -1) {
            blockString = blockStateString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                YungsApiCommon.LOGGER.error("JSON: Malformed property {}. Missing a bracket?", (Object)blockStateString);
                YungsApiCommon.LOGGER.error("Using air instead...");
                return Blocks.f_50016_.m_49966_();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = blockStateString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(blockStateString.charAt(index));
            }
        }
        try {
            blockState = ((Block)Registry.f_122824_.m_7745_(new ResourceLocation(blockString))).m_49966_();
        }
        catch (Exception e) {
            YungsApiCommon.LOGGER.error("JSON: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            YungsApiCommon.LOGGER.error("Using air instead...");
            return Blocks.f_50016_.m_49966_();
        }
        if (properties.size() > 0) {
            blockState = CodecHelper.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState getConfiguredBlockState(BlockState blockState, Map<String, String> properties) {
        Block block = blockState.m_60734_();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean found = false;
            for (Property p : blockState.m_61147_()) {
                Property property = p;
                if (!property.m_61708_().equals(key)) continue;
                Comparable val = property.m_6215_(value).orElse(null);
                if (val == null) {
                    YungsApiCommon.LOGGER.error("JSON: Found null for property {} for block {}", (Object)property, (Object)Registry.f_122824_.m_7447_((Object)block));
                    continue;
                }
                blockState = (BlockState)blockState.m_61124_(property, val);
                found = true;
                break;
            }
            if (found) continue;
            YungsApiCommon.LOGGER.error("JSON: Unable to find property {} for block {}", (Object)key, (Object)Registry.f_122824_.m_7447_((Object)block));
        }
        return blockState;
    }

    private static DataResult<Rotation> readRotation(String name) {
        try {
            return DataResult.success((Object)((Rotation)rotationMap.get((Object)name)));
        }
        catch (ResourceLocationException e) {
            return DataResult.error((String)("Not a valid rotation: " + name + " " + e.getMessage()));
        }
    }

    private static String writeRotation(Rotation rotation) {
        return (String)rotationMap.inverse().get((Object)rotation);
    }

    static {
        rotationMap.put((Object)"none", (Object)Rotation.NONE);
        rotationMap.put((Object)"clockwise_90", (Object)Rotation.CLOCKWISE_90);
        rotationMap.put((Object)"180", (Object)Rotation.CLOCKWISE_180);
        rotationMap.put((Object)"counterclockwise_90", (Object)Rotation.COUNTERCLOCKWISE_90);
    }
}

