/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterConfiguredFeature;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterPlacedFeature;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import com.yungnickyoung.minecraft.yungsapi.module.ConfiguredFeatureModuleForge;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class PlacedFeatureModuleForge {
    public static void processEntries() {
        PlacedFeatureModuleForge.attachIds();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PlacedFeatureModuleForge::registerConfiguredAndPlacedFeatures);
    }

    private static void attachIds() {
        AutoRegistrationManager.CONFIGURED_FEATURES.forEach(data -> {
            AutoRegisterConfiguredFeature autoRegisterConfiguredFeature = (AutoRegisterConfiguredFeature)data.object();
            if (autoRegisterConfiguredFeature.id == null) {
                autoRegisterConfiguredFeature.id = data.name();
            }
        });
        AutoRegistrationManager.PLACED_FEATURES.forEach(data -> {
            AutoRegisterPlacedFeature autoRegisterPlacedFeature = (AutoRegisterPlacedFeature)data.object();
            if (autoRegisterPlacedFeature.id == null) {
                autoRegisterPlacedFeature.id = data.name();
            }
        });
    }

    private static void registerConfiguredAndPlacedFeatures(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ConfiguredFeatureModuleForge.registerConfiguredFeatures();
            AutoRegistrationManager.PLACED_FEATURES.stream().filter(data -> !data.processed()).forEach(PlacedFeatureModuleForge::register);
        });
    }

    private static void register(AutoRegisterField data) {
        AutoRegisterPlacedFeature autoRegisterPlacedFeature = (AutoRegisterPlacedFeature)data.object();
        if (autoRegisterPlacedFeature.id == null) {
            autoRegisterPlacedFeature.id = data.name();
        }
        autoRegisterPlacedFeature.register();
        data.markProcessed();
    }
}

