/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftFeatureConfiguration;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BetterMineshaftPiece
extends StructurePiece {
    public BetterMineshaftFeatureConfiguration config;
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final Set<Material> NON_SOLID_MATERIALS = Set.of(Material.f_76296_, Material.f_76305_, Material.f_76307_, Material.f_76301_);

    public BetterMineshaftPiece(StructurePieceType structurePieceType, int chainLength, BetterMineshaftFeatureConfiguration config, BoundingBox boundingBox) {
        super(structurePieceType, chainLength, boundingBox);
        this.config = config;
    }

    public BetterMineshaftPiece(StructurePieceType structurePieceType, CompoundTag compoundTag) {
        super(structurePieceType, compoundTag);
        this.config = new BetterMineshaftFeatureConfiguration(compoundTag.m_128471_("flammableLegs"), compoundTag.m_128457_("replacementRate"), BetterMineshaftStructureFeature.LegVariant.byId(compoundTag.m_128451_("legVariantIndex")), new BetterMineshaftFeatureConfiguration.MineshaftDecorationChances(compoundTag.m_128457_("vineChance"), compoundTag.m_128457_("snowChance"), compoundTag.m_128457_("cactusChance"), compoundTag.m_128457_("deadBushChance"), compoundTag.m_128457_("mushroomChance"), compoundTag.m_128457_("gravelPileChance"), compoundTag.m_128471_("lushDecorations"), compoundTag.m_128471_("dripstoneDecorations")), new BetterMineshaftFeatureConfiguration.MineshaftBlockStates((BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("mainBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("supportBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("slabBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("gravelBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("stoneWallBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("stoneSlabBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("trapdoorBlockId")), (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("smallLegBlockId"))), new BetterMineshaftFeatureConfiguration.MineshaftBlockstateRandomizers(new BlockStateRandomizer(compoundTag.m_128469_("mainSelector")), new BlockStateRandomizer(compoundTag.m_128469_("floorSelector")), new BlockStateRandomizer(compoundTag.m_128469_("brickSelector")), new BlockStateRandomizer(compoundTag.m_128469_("legSelector"))));
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.m_128379_("flammableLegs", this.config.flammableLegs);
        compoundTag.m_128350_("replacementRate", this.config.replacementRate);
        compoundTag.m_128405_("legVariantIndex", this.config.legVariant.ordinal());
        compoundTag.m_128350_("vineChance", this.config.decorationChances.vineChance);
        compoundTag.m_128350_("snowChance", this.config.decorationChances.snowChance);
        compoundTag.m_128350_("cactusChance", this.config.decorationChances.cactusChance);
        compoundTag.m_128350_("deadBushChance", this.config.decorationChances.deadBushChance);
        compoundTag.m_128350_("mushroomChance", this.config.decorationChances.mushroomChance);
        compoundTag.m_128350_("gravelPileChance", this.config.decorationChances.gravelPileChance);
        compoundTag.m_128379_("lushDecorations", this.config.decorationChances.lushDecorations);
        compoundTag.m_128379_("dripstoneDecorations", this.config.decorationChances.dripstoneDecorations);
        compoundTag.m_128405_("mainBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.mainBlockState));
        compoundTag.m_128405_("supportBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.supportBlockState));
        compoundTag.m_128405_("slabBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.slabBlockState));
        compoundTag.m_128405_("gravelBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.gravelBlockState));
        compoundTag.m_128405_("stoneWallBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.stoneWallBlockState));
        compoundTag.m_128405_("stoneSlabBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.stoneSlabBlockState));
        compoundTag.m_128405_("trapdoorBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.trapdoorBlockState));
        compoundTag.m_128405_("smallLegBlockId", Block.f_49791_.m_7447_((Object)this.config.blockStates.smallLegBlockState));
        compoundTag.m_128365_("mainSelector", (Tag)this.config.blockStateRandomizers.mainRandomizer.saveTag());
        compoundTag.m_128365_("floorSelector", (Tag)this.config.blockStateRandomizers.floorRandomizer.saveTag());
        compoundTag.m_128365_("brickSelector", (Tag)this.config.blockStateRandomizers.brickRandomizer.saveTag());
        compoundTag.m_128365_("legSelector", (Tag)this.config.blockStateRandomizers.legRandomizer.saveTag());
    }

    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
    }

    protected boolean addBarrel(WorldGenLevel world, BoundingBox boundingBox, Random random, BlockPos pos, ResourceLocation lootTableId) {
        if (boundingBox.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50618_) {
            world.m_7731_(pos, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP), 2);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)random, (BlockPos)pos, (ResourceLocation)lootTableId);
            return true;
        }
        return false;
    }

    protected boolean addBarrel(WorldGenLevel world, BoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootTableId) {
        return this.addBarrel(world, boundingBox, random, (BlockPos)this.m_163582_(x, y, z), lootTableId);
    }

    protected void addVines(WorldGenLevel world, BoundingBox boundingBox, Direction facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z)).m_122173_(facing);
                    BlockState nextBlock = this.m_73398_((BlockGetter)world, x + facing.m_122429_(), y + facing.m_122430_(), z + facing.m_122431_(), boundingBox);
                    if (!this.m_73398_((BlockGetter)world, x, y, z, boundingBox).m_60795_() || !Block.m_49918_((VoxelShape)nextBlock.m_60812_((BlockGetter)world, (BlockPos)mutable), (Direction)facing.m_122424_()) || nextBlock.m_60734_().m_49966_() == Blocks.f_50155_.m_49966_() || !(random.nextFloat() < chance)) continue;
                    this.m_73434_(world, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)(facing.m_122434_() == Direction.Axis.X ? facing : facing.m_122424_())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.addVines(world, boundingBox, Direction.EAST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.WEST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.NORTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.SOUTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(WorldGenLevel world, BoundingBox box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
                    BlockState state = this.m_73398_((BlockGetter)world, x, y, z, box);
                    BlockState stateBelow = this.m_73398_((BlockGetter)world, x, y - 1, z, box);
                    if (this.config.decorationChances.snowChance > 0.0f && random.nextFloat() < this.config.decorationChances.snowChance && state.m_60795_() && Blocks.f_50125_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) {
                        this.m_73434_(world, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if (this.config.decorationChances.lushDecorations) {
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            ((ConfiguredFeature)CaveFeatures.f_194950_.m_203334_()).m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            ((ConfiguredFeature)CaveFeatures.f_194955_.m_203334_()).m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            ((ConfiguredFeature)CaveFeatures.f_194956_.m_203334_()).m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (stateBelow.m_60713_(this.config.blockStates.mainBlockState.m_60734_()) && state.m_60795_() && stateBelow.m_60783_((BlockGetter)world, blockPos.m_7495_(), Direction.UP)) {
                            this.m_73434_(world, Blocks.f_152543_.m_49966_(), x, y, z, box);
                        }
                    }
                    if (this.config.decorationChances.dripstoneDecorations) {
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.02f) {
                            ((ConfiguredFeature)CaveFeatures.f_194941_.m_203334_()).m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.02f) {
                            ((ConfiguredFeature)CaveFeatures.f_194943_.m_203334_()).m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                    }
                    if (this.config.decorationChances.cactusChance > 0.0f && random.nextFloat() < this.config.decorationChances.cactusChance && state.m_60795_() && Blocks.f_50128_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) {
                        this.m_73434_(world, (BlockState)Blocks.f_50128_.m_49966_().m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.m_73398_((BlockGetter)world, x, y + 1, z, box).m_60713_(Blocks.f_50016_)) {
                            this.m_73434_(world, (BlockState)Blocks.f_50128_.m_49966_().m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (this.config.decorationChances.deadBushChance > 0.0f && random.nextFloat() < this.config.decorationChances.deadBushChance && state.m_60795_() && (stateBelow.m_60713_(Blocks.f_49992_) || stateBelow.m_60713_(Blocks.f_49993_) || stateBelow.m_60713_(Blocks.f_50352_) || stateBelow.m_60713_(Blocks.f_50287_) || stateBelow.m_60713_(Blocks.f_50288_) || stateBelow.m_60713_(Blocks.f_50291_) || stateBelow.m_60713_(Blocks.f_50299_) || stateBelow.m_60713_(Blocks.f_50493_))) {
                        this.m_73434_(world, Blocks.f_50036_.m_49966_(), x, y, z, box);
                    }
                    if (!(this.config.decorationChances.mushroomChance > 0.0f) || !state.m_60795_() || !Blocks.f_50073_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) continue;
                    float r = random.nextFloat();
                    if (r < this.config.decorationChances.mushroomChance / 2.0f) {
                        this.m_73434_(world, Blocks.f_50073_.m_49966_(), x, y, z, box);
                        continue;
                    }
                    if (!(r < this.config.decorationChances.mushroomChance)) continue;
                    this.m_73434_(world, Blocks.f_50072_.m_49966_(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(WorldGenLevel world, Random random, BoundingBox box, int x, int z, BlockStateRandomizer selector) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, -1, z);
        BlockState state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        while (this.m_73544_(mutable.m_123342_()) > world.m_141937_() + 1 && this.m_163572_(state)) {
            this.m_73434_(world, selector.get(random), x, mutable.m_123342_(), z, box);
            mutable.m_122173_(Direction.DOWN);
            state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        }
    }

    protected boolean generateLegOrChain(WorldGenLevel world, Random random, BoundingBox box, int x, int z, BlockStateRandomizer selector) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, -1, z);
        BlockState state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        boolean lavaBelow = false;
        while (this.m_73544_(mutable.m_123342_()) > world.m_141937_() + 1 && this.m_163572_(state)) {
            if (state.m_60713_(Blocks.f_49991_)) {
                lavaBelow = true;
                break;
            }
            mutable.m_122173_(Direction.DOWN);
            state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        }
        if (lavaBelow) {
            mutable = this.m_163582_(x, 0, z);
            if (!this.f_73383_.m_71051_((Vec3i)mutable)) {
                return false;
            }
            int realChainY = this.m_73544_(0);
            int length = 1;
            boolean canGenerateChain = true;
            while (canGenerateChain) {
                if (canGenerateChain) {
                    mutable.m_142448_(realChainY + length);
                    BlockState currBlock = world.m_8055_((BlockPos)mutable);
                    boolean currBlockCanBeReplaced = this.m_163572_(currBlock);
                    if (!currBlockCanBeReplaced && this.canHangChainBelow((LevelReader)world, (BlockPos)mutable, currBlock)) {
                        world.m_7731_((BlockPos)mutable.m_142448_(realChainY + 1), this.config.blockStates.supportBlockState, 2);
                        BetterMineshaftPiece.fillColumnBetween(world, Blocks.f_50184_.m_49966_(), mutable, realChainY + 2, realChainY + length);
                        return false;
                    }
                    canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.m_123342_() < world.m_151558_() - 1;
                }
                ++length;
            }
        } else {
            this.generateLeg(world, random, box, x, z, selector);
            return true;
        }
        return false;
    }

    protected void generatePillarDownOrChainUp(WorldGenLevel world, Random random, BoundingBox boundingBox, int x, int z, int pillarStartY, int chainStartY, BlockState chainBlock) {
        BlockPos.MutableBlockPos mutable = this.m_163582_(x, pillarStartY, z);
        if (!boundingBox.m_71051_((Vec3i)mutable)) {
            return;
        }
        int realPillarY = this.m_73544_(pillarStartY);
        int realChainY = this.m_73544_(chainStartY);
        int length = 1;
        boolean canGenerateLeg = true;
        boolean canGenerateChain = true;
        while (canGenerateLeg || canGenerateChain) {
            boolean currBlockCanBeReplaced;
            BlockState currBlock;
            if (canGenerateLeg) {
                mutable.m_142448_(realPillarY - length);
                currBlock = world.m_8055_((BlockPos)mutable);
                boolean bl = currBlockCanBeReplaced = this.m_163572_(currBlock) && !currBlock.m_60713_(Blocks.f_49991_);
                if (!currBlockCanBeReplaced && this.canPlaceColumnOnTopOf(currBlock)) {
                    BetterMineshaftPiece.fillColumnBetween(world, this.config.blockStates.smallLegBlockState, mutable, realPillarY - length + 1, realPillarY);
                    return;
                }
                boolean bl2 = canGenerateLeg = length <= 20 && currBlockCanBeReplaced && mutable.m_123342_() > world.m_141937_() + 1;
            }
            if (canGenerateChain) {
                mutable.m_142448_(realChainY + length);
                currBlock = world.m_8055_((BlockPos)mutable);
                currBlockCanBeReplaced = this.m_163572_(currBlock);
                if (!currBlockCanBeReplaced && this.canHangChainBelow((LevelReader)world, (BlockPos)mutable, currBlock)) {
                    world.m_7731_((BlockPos)mutable.m_142448_(realChainY + 1), chainBlock, 2);
                    BetterMineshaftPiece.fillColumnBetween(world, Blocks.f_50184_.m_49966_(), mutable, realChainY + 2, realChainY + length);
                    return;
                }
                canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.m_123342_() < world.m_151558_() - 1;
            }
            ++length;
        }
    }

    protected void generatePillarDownOrChainUp(WorldGenLevel world, Random random, BoundingBox boundingBox, int x, int y, int z) {
        this.generatePillarDownOrChainUp(world, random, boundingBox, x, z, y, y, this.config.blockStates.supportBlockState);
    }

    private boolean canPlaceColumnOnTopOf(BlockState blockState) {
        return !blockState.m_60713_(Blocks.f_50156_) && !blockState.m_60713_(Blocks.f_49991_);
    }

    private boolean canHangChainBelow(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return Block.m_49863_((LevelReader)levelReader, (BlockPos)blockPos, (Direction)Direction.DOWN) && !(blockState.m_60734_() instanceof FallingBlock);
    }

    protected boolean m_163572_(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60767_().m_76332_() || blockState.m_60713_(Blocks.f_152475_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50038_) || blockState.m_60713_(Blocks.f_152588_) || blockState.m_60713_(Blocks.f_152538_) || blockState.m_60713_(Blocks.f_152539_) || blockState.m_60713_(Blocks.f_152543_) || blockState.m_60713_(Blocks.f_50125_);
    }

    protected void fill(WorldGenLevel world, BoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.m_73398_((BlockGetter)world, x, y, z, boundingBox) == Blocks.f_50184_.m_49966_() || !blockState.m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void fill(WorldGenLevel world, BoundingBox boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState;
                    if (this.m_73398_((BlockGetter)world, x, y, z, boundingBox) == Blocks.f_50184_.m_49966_() || !(blockState = selector.get(random)).m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(WorldGenLevel world, BoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || !currState.m_60795_() && currState != Blocks.f_50184_.m_49966_() || !blockState.m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(WorldGenLevel world, BoundingBox boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState;
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || !currState.m_60795_() && currState != Blocks.f_50184_.m_49966_() || !(blockState = selector.get(random)).m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected static void fillColumnBetween(WorldGenLevel worldGenLevel, BlockState blockState, BlockPos.MutableBlockPos mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos.m_142448_(y), blockState, 2);
        }
    }

    protected static void fillColumnBetween(WorldGenLevel worldGenLevel, Random random, BlockStateRandomizer selector, BlockPos.MutableBlockPos mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos.m_142448_(y), selector.get(random), 2);
        }
    }

    protected void chanceFill(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance) || !blockState.m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceFill(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.m_73434_(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox)) == null || !currState.m_60795_()) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || currState == Blocks.f_50184_.m_49966_() || currState.m_60767_() != Material.f_76305_ && currState.m_60767_() != Material.f_76307_ && (!(random.nextFloat() < chance) || currState.m_60795_())) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockStateRandomizer selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || currState == Blocks.f_50184_.m_49966_() || currState.m_60767_() != Material.f_76305_ && currState.m_60767_() != Material.f_76307_ && (!(random.nextFloat() < chance) || currState.m_60795_())) continue;
                    BlockState blockState = selector.get(random);
                    if (currState.m_60767_() == Material.f_76305_ || currState.m_60767_() == Material.f_76307_) {
                        for (int numAttempts = 0; (blockState == Blocks.f_50016_.m_49966_() || blockState == Blocks.f_50627_.m_49966_()) && numAttempts < 10; ++numAttempts) {
                            blockState = selector.get(random);
                        }
                    }
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceSolid(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox)) == null || currState == Blocks.f_50184_.m_49966_() || NON_SOLID_MATERIALS.contains(currState.m_60767_())) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceAddBlock(WorldGenLevel world, Random random, float chance, BlockState block, int x, int y, int z, BoundingBox boundingBox) {
        if (random.nextFloat() < chance && block.m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z))) {
            this.m_73434_(world, block, x, y, z, boundingBox);
        }
    }

    protected void chanceReplaceAir(WorldGenLevel world, Random random, float chance, BlockState block, int x, int y, int z, BoundingBox boundingBox) {
        if (random.nextFloat() < chance && block.m_60710_((LevelReader)world, (BlockPos)this.m_163582_(x, y, z)) && block.m_60713_(Blocks.f_50016_) || block.m_60713_(Blocks.f_50627_)) {
            this.m_73434_(world, block, x, y, z, boundingBox);
        }
    }

    protected BlockState getBlockAtFixed(BlockGetter blockGetter, int x, int y, int z, BoundingBox boundingBox) {
        BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
        return !boundingBox.m_71051_((Vec3i)blockPos) ? null : blockGetter.m_8055_((BlockPos)blockPos);
    }
}

