/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.module;

import com.yungnickyoung.minecraft.yungsbridges.YungsBridgesCommon;
import com.yungnickyoung.minecraft.yungsbridges.module.FeatureModule;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.BridgeFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.MultipleAttemptSingleRandomFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacement;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacementConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.RngInitializerPlacement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ConfiguredFeatureModule {
    private static final List<PlacedFeature> PLACED_BRIDGES = new ArrayList<PlacedFeature>();
    public static final ConfiguredFeature<?, ?> BRIDGE_LIST_FEATURE_CONFIGURED;
    public static final PlacedFeature BRIDGE_LIST_FEATURE_PLACED;

    public static void registerConfiguredFeatures() {
        ConfiguredFeatureModule.registerConfiguredFeature(BRIDGE_LIST_FEATURE_CONFIGURED, "bridge_list");
    }

    public static void registerPlacedFeatures() {
        ConfiguredFeatureModule.registerPlacedFeature(BRIDGE_LIST_FEATURE_PLACED, "bridge_list");
    }

    private static void registerConfiguredFeature(ConfiguredFeature<?, ?> feature, String id) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("yungsbridges", id), feature);
    }

    private static void registerPlacedFeature(PlacedFeature feature, String id) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("yungsbridges", id), (Object)feature);
    }

    private static void addLargeBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.largeBridges);
    }

    private static void addMediumBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.mediumBridges);
    }

    private static void addSmallBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.smallBridges);
    }

    private static void addBridge(String id, BridgePlacementConfig placementConfig, int chance) {
        BridgeFeatureConfig featureConfig = new BridgeFeatureConfig(id);
        ConfiguredFeature configuredFeature = new ConfiguredFeature(FeatureModule.BRIDGE, (FeatureConfiguration)featureConfig);
        PlacedFeature placedFeature = new PlacedFeature(Holder.m_205709_((Object)configuredFeature), List.of(BridgePlacement.of(placementConfig), RarityFilter.m_191900_((int)chance), RngInitializerPlacement.randomized()));
        ConfiguredFeature rotatedConfiguredFeature = new ConfiguredFeature(FeatureModule.BRIDGE, (FeatureConfiguration)featureConfig.rotatedCopy());
        PlacedFeature placedRotatedFeature = new PlacedFeature(Holder.m_205709_((Object)rotatedConfiguredFeature), List.of(BridgePlacement.of(placementConfig.rotatedCopy()), RarityFilter.m_191900_((int)chance), RngInitializerPlacement.randomized()));
        PLACED_BRIDGES.add(placedFeature);
        PLACED_BRIDGES.add(placedRotatedFeature);
    }

    static {
        ConfiguredFeatureModule.addLargeBridge("bridge/stone/31_0", new BridgePlacementConfig(31, 5, 4, 28).widthOffset(2).solidBlocks(3));
        ConfiguredFeatureModule.addLargeBridge("bridge/wood/27_0", new BridgePlacementConfig(27, 5, 2, 26).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/24_0", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/24_0_broken", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/22_0", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/22_0_broken", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/wood/17_0", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/wood/17_0_broken", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/16_0", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/16_0_broken", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/15_1", new BridgePlacementConfig(15, 5, 2, 14).widthOffset(1).solidBlocks(2));
        BRIDGE_LIST_FEATURE_CONFIGURED = new ConfiguredFeature(FeatureModule.MULTIPLE_ATTEMPT_SINGLE_RANDOM, (FeatureConfiguration)new MultipleAttemptSingleRandomFeatureConfig(PLACED_BRIDGES));
        BRIDGE_LIST_FEATURE_PLACED = new PlacedFeature(Holder.m_205709_(BRIDGE_LIST_FEATURE_CONFIGURED), List.of(BiomeFilter.m_191561_()));
    }
}

