/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.entities;

import com.obscuria.aquamirae.AquamiraeConfig;
import com.obscuria.aquamirae.AquamiraeMod;
import com.obscuria.aquamirae.client.AquamiraeAmbient;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.aquamirae.registry.AquamiraeParticleTypes;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.aquamirae.world.entities.IShipGraveyardEntity;
import com.obscuria.obscureapi.client.animations.HekateProvider;
import com.obscuria.obscureapi.client.animations.IHekateProvider;
import com.obscuria.obscureapi.utils.TextHelper;
import com.obscuria.obscureapi.world.entities.ChakraEntity;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class CaptainCornelia
extends Monster
implements IShipGraveyardEntity,
IHekateProvider {
    private final HekateProvider ANIMATIONS = new HekateProvider((Entity)this);
    private static final EntityDataAccessor<Integer> ATTACK = SynchedEntityData.m_135353_(CaptainCornelia.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> REGENERATION = SynchedEntityData.m_135353_(CaptainCornelia.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent((Component)((Boolean)AquamiraeConfig.Common.stylizedBossbar.get() != false ? TextHelper.component((String)"1").m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("aquamirae", "bossbars"))) : this.m_5446_()), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);

    public CaptainCornelia(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CaptainCornelia>)((EntityType)AquamiraeEntities.CAPTAIN_CORNELIA.get()), world);
    }

    public CaptainCornelia(EntityType<CaptainCornelia> type, Level world) {
        super(type, world);
        this.f_21364_ = 100;
        this.m_21530_();
        this.m_8061_(EquipmentSlot.MAINHAND, AquamiraeMod.winterEvent() ? ((Item)AquamiraeItems.SWEET_LANCE.get()).m_7968_() : ((Item)AquamiraeItems.CORAL_LANCE.get()).m_7968_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return 0.0;
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK, (Object)0);
        this.m_20088_().m_135372_(REGENERATION, (Object)((Integer)AquamiraeConfig.Common.corneliaSkillRegeneration.get()));
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag data = new CompoundTag();
        data.m_128405_("Attack", ((Integer)this.m_20088_().m_135370_(ATTACK)).intValue());
        data.m_128405_("Regeneration", ((Integer)this.m_20088_().m_135370_(REGENERATION)).intValue());
        tag.m_128365_("CorneliaData", (Tag)data);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag data = (CompoundTag)tag.m_128423_("CorneliaData");
        if (data == null) {
            return;
        }
        this.m_20088_().m_135381_(ATTACK, (Object)data.m_128451_("Attack"));
        this.m_20088_().m_135381_(REGENERATION, (Object)data.m_128451_("Regeneration"));
    }

    public HekateProvider getHekateProvider() {
        return this.ANIMATIONS;
    }

    public void m_6075_() {
        Vec3 center;
        int attack = (Integer)this.m_20088_().m_135370_(ATTACK);
        this.m_20088_().m_135381_(ATTACK, (Object)(attack - 1));
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.3 && (Integer)this.m_20088_().m_135370_(REGENERATION) > 0 && !this.m_21023_(MobEffects.f_19620_)) {
            this.rage();
        }
        if ((double)this.m_21223_() <= (double)this.m_21233_() * 0.1 && !this.m_21023_(MobEffects.f_19613_)) {
            this.m_5634_(0.5f);
        }
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double distance = this.m_20280_((Entity)target);
            this.f_21365_.m_148051_((Entity)target);
            this.f_20883_ = this.f_20885_;
            if (!this.ANIMATIONS.isPlaying("attack")) {
                if (distance < 3.0 || this.m_21023_(MobEffects.f_19620_)) {
                    this.ANIMATIONS.play("attack", Math.random() < 0.5 ? 40 : 20);
                } else if (distance < 25.0 && this.f_19796_.nextInt(100) == 1) {
                    this.ANIMATIONS.play("attack", Math.random() < 0.5 ? 40 : 20);
                } else if (distance < 600.0 && this.f_19796_.nextInt(200) == 1) {
                    this.ANIMATIONS.play("attack", 60);
                }
            }
            if (this.ANIMATIONS.getTick("attack") == 50) {
                target.m_20256_(new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82505_(new Vec3(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_())).m_82490_(0.25));
                if (target instanceof Player) {
                    Player player2 = (Player)target;
                    player2.f_19864_ = true;
                }
            }
            if (this.ANIMATIONS.getTick("attack") == 8 || this.ANIMATIONS.getTick("attack") == 28) {
                this.m_20256_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82505_(new Vec3(target.m_20185_(), target.m_20186_() + (double)0.1f, target.m_20189_())).m_82490_((double)0.2f));
            }
            if (this.ANIMATIONS.getTick("attack") == 26 && distance < 9.0) {
                this.m_7327_((Entity)target);
            }
            if (this.ANIMATIONS.getTick("attack") == 6 && distance < 12.0) {
                this.m_7327_((Entity)target);
            }
            if (this.m_5842_() && !this.m_21023_(MobEffects.f_19620_)) {
                this.m_20256_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82505_(new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_())).m_82490_((double)0.04f));
            } else if (this.m_20069_() && !this.m_21023_(MobEffects.f_19620_)) {
                this.m_20256_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82505_(new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_())).m_82490_((double)0.04f).m_82520_(0.0, (double)0.08f, 0.0));
            }
        }
        this.ANIMATIONS.playSound("attack", 40, "aquamirae:entity.captain_cornelia.attack_1", SoundSource.HOSTILE, 2.0f, 1.0f);
        this.ANIMATIONS.playSound("attack", 20, "aquamirae:entity.captain_cornelia.attack_2", SoundSource.HOSTILE, 2.0f, 1.0f);
        if (this.ANIMATIONS.getTick("attack") > 10) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 3, false, false));
        }
        if (this.m_21023_(MobEffects.f_19620_) && !this.m_183503_().m_5776_()) {
            center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            List<LivingEntity> list = this.m_183503_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(10.0), e -> true).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center))).toList();
            MobEffectInstance LEVITATION = this.m_21124_(MobEffects.f_19620_);
            int DURATION = LEVITATION == null ? 0 : LEVITATION.m_19557_();
            list.forEach(entity -> {
                Player player;
                if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
                    return;
                }
                if (entity.m_21233_() <= 100.0f) {
                    if (DURATION > 1) {
                        double radius = 5.0;
                        Vec3 orbit = new Vec3(center.f_82479_ + Math.cos((float)entity.f_19797_ * -0.1f) * 5.0, center.f_82480_, center.f_82481_ + Math.sin((float)entity.f_19797_ * -0.1f) * 5.0);
                        entity.m_20256_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82505_(orbit).m_82490_((double)0.2f));
                        if (entity instanceof Player) {
                            Player _player = (Player)entity;
                            _player.f_19864_ = true;
                        }
                    } else if (DURATION == 1) {
                        entity.m_20256_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82505_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).m_82490_((double)0.2f));
                        if (entity instanceof Player) {
                            Player _player = (Player)entity;
                            _player.f_19864_ = true;
                        }
                    }
                }
            });
            this.getPersistentData().m_128347_("Par1", this.getPersistentData().m_128459_("Par1") + 1.0);
            Level level = this.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (this.getPersistentData().m_128459_("Par1") > 1.0) {
                    this.getPersistentData().m_128347_("Par1", 0.0);
                    server.m_8767_((ParticleOptions)((SimpleParticleType)AquamiraeParticleTypes.GHOST.get()), this.m_20185_(), this.m_20186_() - 0.2, this.m_20189_(), 1, 0.3, 0.1, 0.3, 0.1);
                }
            }
            if (this.m_20069_()) {
                this.m_20256_(new Vec3(0.0, (double)0.4f, 0.0));
            }
        }
        this.getPersistentData().m_128347_("Par2", this.getPersistentData().m_128459_("Par2") + 1.0);
        Level list = this.m_183503_();
        if (list instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)list;
            if (this.getPersistentData().m_128459_("Par2") > 9.0) {
                this.getPersistentData().m_128347_("Par2", 0.0);
                server.m_8767_((ParticleOptions)((SimpleParticleType)AquamiraeParticleTypes.GHOST_SHINE.get()), this.m_20185_(), this.m_20186_() + 1.7, this.m_20189_(), 1, 0.15, 0.1, 0.15, 0.1);
            }
        }
        center = this.m_20318_(1.0f);
        List<Player> players = this.m_183503_().m_6443_(Player.class, new AABB(center, center).m_82400_(32.0), e -> true).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(center))).toList();
        players.forEach(player -> {
            if (player.m_183503_().m_5776_()) {
                AquamiraeAmbient.playCorneliaMusic(player);
            }
        });
        super.m_6075_();
    }

    public void rage() {
        this.m_20088_().m_135381_(REGENERATION, (Object)((Integer)this.m_20088_().m_135370_(REGENERATION) - 1));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 0, false, false));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 8, false, false));
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
            LightningBolt entityToSpawn = new LightningBolt(EntityType.f_20465_, (Level)serverLevel);
            entityToSpawn.m_20219_(Vec3.m_82539_((Vec3i)pos));
            entityToSpawn.m_20874_(true);
            serverLevel.m_7967_((Entity)entityToSpawn);
            serverLevel.m_5594_(null, pos, (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HORN.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            serverLevel.m_5594_(null, pos, (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_RAGE.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            ChakraEntity.summonChakra((LivingEntity)this, (EntityType)((EntityType)AquamiraeEntities.POISONED_CHAKRA.get()), (Level)this.f_19853_, null, (int)5, (float)0.0f, (int)600, (int)1000);
            ChakraEntity.summonChakra((LivingEntity)this, (EntityType)((EntityType)AquamiraeEntities.POISONED_CHAKRA.get()), (Level)this.f_19853_, null, (int)5, (float)0.33f, (int)600, (int)1000);
            ChakraEntity.summonChakra((LivingEntity)this, (EntityType)((EntityType)AquamiraeEntities.POISONED_CHAKRA.get()), (Level)this.f_19853_, null, (int)5, (float)0.66f, (int)600, (int)1000);
        }
    }

    protected void m_5907_() {
        if (Math.random() <= (double)0.2f) {
            ItemEntity item = new ItemEntity(EntityType.f_20461_, this.f_19853_);
            item.m_32045_(this.m_21205_());
            item.m_20219_(this.m_20182_());
            this.f_19853_.m_7967_((Entity)item);
        }
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_AMBIENT.get();
    }

    public SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_DEATH.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19372_()) {
            return false;
        }
        if (source.m_19385_().equals("trident")) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        Level level = this.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_5594_(null, new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()), (SoundEvent)AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HORN.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
        }
        this.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 120, 0, false, false));
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22279_, (Double)AquamiraeConfig.Common.corneliaMovementSpeed.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22276_, (Double)AquamiraeConfig.Common.corneliaMaxHealth.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22284_, (Double)AquamiraeConfig.Common.corneliaArmor.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22281_, (Double)AquamiraeConfig.Common.corneliaAttackDamage.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22277_, (Double)AquamiraeConfig.Common.corneliaFollowRange.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22282_, (Double)AquamiraeConfig.Common.corneliaAttackKnockback.get());
        AquamiraeMod.loadFromConfig((LivingEntity)this, Attributes.f_22278_, (Double)AquamiraeConfig.Common.corneliaKnockbackResistance.get());
        return super.m_6518_(world, difficulty, reason, livingdata, tag);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, 2.0);
    }
}

