/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.items.armor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.obscuria.aquamirae.AquamiraeConfig;
import com.obscuria.aquamirae.AquamiraeMod;
import com.obscuria.aquamirae.client.models.armor.ModelThreeBoltArmor;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.world.classes.IAbilityItem;
import com.obscuria.obscureapi.world.classes.IBonusItem;
import com.obscuria.obscureapi.world.classes.IClassItem;
import com.obscuria.obscureapi.world.classes.ObscureAbility;
import com.obscuria.obscureapi.world.classes.ObscureBonus;
import com.obscuria.obscureapi.world.classes.ObscureClass;
import com.obscuria.obscureapi.world.classes.ObscureType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;

public abstract class ThreeBoltArmorItem
extends ArmorItem
implements IClassItem,
IAbilityItem,
IBonusItem {
    public final EquipmentSlot BONUS_SLOT;
    public final ObscureAbility ABILITY_HALFSET = new ObscureAbility((Item)this, "three_bolt_armor_half", ObscureAbility.Cost.NONE, 0);
    public final ObscureAbility ABILITY_FULLSET = new ObscureAbility((Item)this, "three_bolt_armor_full", ObscureAbility.Cost.NONE, 0);
    public final ObscureBonus BONUS_TOP = new ObscureBonus(AquamiraeMod.SEA_WOLF, ObscureAPI.Types.ARMOR, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT, 30);
    public final ObscureBonus BONUS_BOTTOM = new ObscureBonus(AquamiraeMod.SEA_WOLF, ObscureAPI.Types.WEAPON, ObscureBonus.Type.POWER, ObscureBonus.Operation.PERCENT, 30);

    public ThreeBoltArmorItem(EquipmentSlot slot, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_7366_(@NotNull EquipmentSlot slot) {
                return (new int[]{13, 15, 16, 11})[slot.m_20749_()] * 75;
            }

            public int m_7365_(@NotNull EquipmentSlot slot) {
                return (new int[]{3, 5, 5, 7})[slot.m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            @NotNull
            public SoundEvent m_7344_() {
                return SoundEvents.f_11677_;
            }

            @NotNull
            public Ingredient m_6230_() {
                return Ingredient.f_43901_;
            }

            @NotNull
            public String m_6082_() {
                return "three_bolt";
            }

            public float m_6651_() {
                return 2.0f;
            }

            public float m_6649_() {
                return 0.1f;
            }
        }, slot, properties.m_41491_(AquamiraeMod.TAB));
        this.BONUS_SLOT = slot;
    }

    public List<ObscureAbility> getObscureAbilities() {
        return List.of(this.ABILITY_FULLSET, this.ABILITY_HALFSET);
    }

    public List<ObscureBonus> getObscureBonuses() {
        if (this.BONUS_SLOT == EquipmentSlot.HEAD || this.BONUS_SLOT == EquipmentSlot.CHEST) {
            return Collections.singletonList(this.BONUS_TOP);
        }
        return Collections.singletonList(this.BONUS_BOTTOM);
    }

    public ObscureClass getObscureClass() {
        return AquamiraeMod.SEA_WOLF;
    }

    public ObscureType getObscureType() {
        return ObscureAPI.Types.ARMOR;
    }

    public static class Boots
    extends ThreeBoltArmorItem {
        public Boots() {
            super(EquipmentSlot.FEET, new Item.Properties());
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @OnlyIn(value=Dist.CLIENT)
                @NotNull
                public HumanoidModel<? extends LivingEntity> getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).right_boot, "left_leg", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).left_boot)));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "aquamirae:textures/entity/armor/three_bolt_boots.png";
        }
    }

    public static class Leggings
    extends ThreeBoltArmorItem {
        public Leggings() {
            super(EquipmentSlot.LEGS, new Item.Properties());
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @OnlyIn(value=Dist.CLIENT)
                @NotNull
                public HumanoidModel<? extends LivingEntity> getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).leggings_body, "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).right_leg, "left_leg", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).left_leg)));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "aquamirae:textures/entity/armor/three_bolt_leggings.png";
        }
    }

    public static class Chestplate
    extends ThreeBoltArmorItem {
        public Chestplate() {
            super(EquipmentSlot.CHEST, new Item.Properties());
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @OnlyIn(value=Dist.CLIENT)
                @NotNull
                public HumanoidModel<? extends LivingEntity> getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).body, "left_arm", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).left_arm, "right_arm", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).right_arm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "aquamirae:textures/entity/armor/three_bolt_chestplate.png";
        }

        public void onArmorTick(ItemStack stack, Level world, Player entity) {
            if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ThreeBoltArmorItem && entity.m_20146_() <= 0) {
                entity.m_20301_(280);
                if (stack.m_41629_(10, new Random(), null)) {
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                }
                if (!entity.m_183503_().m_5776_()) {
                    entity.m_183503_().m_5594_(null, new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()), (SoundEvent)AquamiraeSounds.EFFECT_OXYGEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public static class Helmet
    extends ThreeBoltArmorItem {
        public Helmet() {
            super(EquipmentSlot.HEAD, new Item.Properties());
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @NotNull
                public HumanoidModel<? extends LivingEntity> getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelThreeBoltArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelThreeBoltArmor.LAYER_LOCATION)).head, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }

                public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTick) {
                    if (!((Boolean)AquamiraeConfig.Client.overlay.get()).booleanValue()) {
                        return;
                    }
                    RenderSystem.m_69465_();
                    RenderSystem.m_69458_((boolean)false);
                    RenderSystem.m_69453_();
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("aquamirae", "textures/screens/three_bolt_overlay.png"));
                    Tesselator tesselator = Tesselator.m_85913_();
                    BufferBuilder bufferbuilder = tesselator.m_85915_();
                    bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                    bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                    bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                    bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                    tesselator.m_85914_();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_69482_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "aquamirae:textures/entity/armor/three_bolt_helmet.png";
        }
    }
}

