/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.awesomedungeonnether;

import com.jtorleonstudios.awesomedungeonnether.AwsNetherConfig;
import com.jtorleonstudios.libraryferret.worldgen.structures.AwesomeStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import org.jetbrains.annotations.NotNull;

public class AwsNetherStructure
extends AwesomeStructure {
    public AwsNetherStructure() {
        this(1, 2);
    }

    public AwsNetherStructure(int size, int distanceMax) {
        this(size, distanceMax, AwsNetherStructure::canGenerate);
    }

    public AwsNetherStructure(int size, int distanceMaxFromCenter, BiFunction<PieceGeneratorSupplier.Context<JigsawConfiguration>, Heightmap.Types, Boolean> canGenerate) {
        super(AwsNetherStructure::initialPosition, Heightmap.Types.WORLD_SURFACE_WG, false, size, distanceMaxFromCenter, canGenerate);
    }

    public boolean bindEnabledFromConfiguration(String uniqueIdentifierStartPool) {
        return AwsNetherConfig.get(uniqueIdentifierStartPool).isEnabled();
    }

    public static boolean canGenerate(PieceGeneratorSupplier.Context<JigsawConfiguration> ctx, Heightmap.Types heightmapType) {
        return !AwsNetherStructure.getPotentialPosition(ctx).isEmpty();
    }

    private static List<BlockPos.MutableBlockPos> getPotentialPosition(PieceGeneratorSupplier.Context<JigsawConfiguration> ctx) {
        BlockPos centerOfChunk = ctx.f_197355_().m_151394_(0);
        int landHeight = ctx.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, ctx.f_197357_()) - 50;
        BlockPos.MutableBlockPos bpm = new BlockPos.MutableBlockPos(centerOfChunk.m_123341_(), 0, centerOfChunk.m_123343_());
        NoiseColumn columnOfBlocks = ctx.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), ctx.f_197357_());
        ArrayList<BlockPos.MutableBlockPos> data = new ArrayList<BlockPos.MutableBlockPos>();
        for (int i = 0; i < landHeight; ++i) {
            BlockState beforeMoveState = columnOfBlocks.m_183556_(bpm.m_123342_());
            boolean beforeMoveIsGround = !beforeMoveState.m_60795_() && beforeMoveState.m_60819_().m_76178_();
            bpm.m_122173_(Direction.UP);
            if (!beforeMoveIsGround || !columnOfBlocks.m_183556_(bpm.m_123342_()).m_60795_()) continue;
            data.add(bpm.m_122032_());
        }
        return data;
    }

    private static BlockPos initialPosition(PieceGeneratorSupplier.Context<JigsawConfiguration> ctx, Heightmap.Types types) {
        List<BlockPos.MutableBlockPos> data = AwsNetherStructure.getPotentialPosition(ctx);
        return (BlockPos)data.get(new Random().nextInt(data.size()));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

