/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.block_entity;

import com.legacy.blue_skies.client.gui.menu.SnowcapOvenMenu;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.objects.FreezingRecipe;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.util.LogicUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SnowcapOvenBlockEntity
extends AbstractFurnaceBlockEntity {
    public final RecipeType<SmeltingRecipe> ovenRecipeType;

    public SnowcapOvenBlockEntity(BlockPos pos, BlockState state) {
        super(SkiesBlockEntityTypes.SNOWCAP_OVEN, pos, state, RecipeType.f_44108_);
        this.f_58310_ = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        this.ovenRecipeType = RecipeType.f_44108_;
    }

    protected Component m_6820_() {
        return new TranslatableComponent(SkiesBlocks.snowcap_oven.m_7705_());
    }

    protected SnowcapOvenMenu createMenu(int id, Inventory playerInv) {
        return new SnowcapOvenMenu(id, playerInv, (Container)this, this.f_58311_);
    }

    public static void ovenServerTick(Level level, BlockPos pos, BlockState state, SnowcapOvenBlockEntity oven) {
        boolean isBurning = oven.isBurning();
        boolean shouldUpdate = false;
        if (oven.isBurning()) {
            oven.setBurnTime(oven.getBurnTime() - 1);
        }
        ItemStack fuelStack = (ItemStack)oven.f_58310_.get(1);
        if (oven.isBurning() || !fuelStack.m_41619_() && !((ItemStack)oven.f_58310_.get(0)).m_41619_()) {
            Recipe recipe = level.m_7465_().m_44015_(oven.ovenRecipeType, (Container)oven, level).orElse(null);
            int maxStackSize = oven.m_6893_();
            if (!oven.isBurning() && oven.canBurn(recipe, (NonNullList<ItemStack>)oven.f_58310_, maxStackSize)) {
                oven.setBurnTime(oven.m_7743_(fuelStack));
                oven.setRecipesUsed(oven.getBurnTime());
                if (oven.isBurning()) {
                    shouldUpdate = true;
                    if (fuelStack.hasContainerItem()) {
                        oven.freezeFuel(fuelStack);
                        oven.f_58310_.set(1, (Object)fuelStack.getContainerItem());
                    } else if (!fuelStack.m_41619_()) {
                        oven.freezeFuel(fuelStack);
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            oven.f_58310_.set(1, (Object)fuelStack.getContainerItem());
                        }
                    }
                }
            }
            if (oven.isBurning() && oven.canBurn(recipe, (NonNullList<ItemStack>)oven.f_58310_, maxStackSize)) {
                oven.setCookTimeVar(oven.getCookTimeVar() + 1);
                if (oven.getCookTimeVar() == oven.getCookTimeTotal()) {
                    oven.setCookTimeVar(0);
                    oven.setCookTimeTotal(SnowcapOvenBlockEntity.getTotalCookTime(level, oven.ovenRecipeType, (Container)oven));
                    oven.smelt(recipe);
                    shouldUpdate = true;
                }
            } else {
                oven.setCookTimeVar(0);
            }
        } else if (!oven.isBurning() && oven.getCookTimeVar() > 0) {
            oven.setCookTimeVar(Mth.m_14045_((int)(oven.getCookTimeVar() - 2), (int)0, (int)oven.getCookTimeTotal()));
        }
        if (isBurning != oven.isBurning()) {
            shouldUpdate = true;
            level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(oven.isBurning())), 3);
        }
        if (shouldUpdate) {
            oven.m_6596_();
        }
    }

    private static int getTotalCookTime(Level level, RecipeType<SmeltingRecipe> recipeType, Container container) {
        return level.m_7465_().m_44015_(recipeType, container, level).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    protected int m_7743_(ItemStack fuel) {
        if (SnowcapOvenBlockEntity.isFuel(fuel)) {
            int value = ((FreezingRecipe)BlueSkiesData.SNOWCAP_OVEN_FREEZING.getValue(fuel.m_41720_())).fuelAmount;
            int damage = fuel.m_41773_();
            if (damage > 0) {
                int maxDamage = fuel.m_41776_();
                int scaledValue = (int)((double)(maxDamage - damage) / (double)maxDamage * (double)value);
                return LogicUtil.bind(0, scaledValue, value);
            }
            return value;
        }
        return 0;
    }

    private void freezeFuel(ItemStack fuelStack) {
        if (fuelStack != null && !fuelStack.m_41619_() && SnowcapOvenBlockEntity.isFuel(fuelStack)) {
            FreezingRecipe recipe = (FreezingRecipe)BlueSkiesData.SNOWCAP_OVEN_FREEZING.getValue(fuelStack.m_41720_());
            ItemStack freezingOutput = recipe.getOutput();
            ItemStack frozenStack = (ItemStack)this.f_58310_.get(3);
            if (frozenStack.m_41619_()) {
                int damage = fuelStack.m_41773_();
                int outputMaxDamage = freezingOutput.m_41776_();
                if (damage > 0 && outputMaxDamage > 0) {
                    int maxDamage = fuelStack.m_41776_();
                    int scaledOutputDamage = (int)((double)damage / (double)maxDamage * (double)outputMaxDamage);
                    freezingOutput.m_41721_(LogicUtil.bind(0, scaledOutputDamage, outputMaxDamage));
                }
                this.f_58310_.set(3, (Object)freezingOutput.m_41777_());
            } else if (frozenStack.m_41720_() == freezingOutput.m_41720_() && frozenStack.m_41613_() < frozenStack.m_41741_()) {
                frozenStack.m_41769_(freezingOutput.m_41613_());
                if (frozenStack.m_41613_() > frozenStack.m_41741_()) {
                    frozenStack.m_41764_(frozenStack.m_41741_());
                }
            }
        }
    }

    private boolean isBurning() {
        return this.getBurnTime() > 0;
    }

    private void smelt(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canBurn(recipe, (NonNullList<ItemStack>)this.f_58310_, this.m_6893_())) {
            ItemStack rawStack = (ItemStack)this.f_58310_.get(0);
            ItemStack recipeOutput = recipe.m_8043_();
            ItemStack outputStack = (ItemStack)this.f_58310_.get(2);
            if (outputStack.m_41619_()) {
                this.f_58310_.set(2, (Object)recipeOutput.m_41777_());
            } else if (outputStack.m_41720_() == recipeOutput.m_41720_()) {
                outputStack.m_41769_(recipeOutput.m_41613_());
            }
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            if (rawStack.m_41720_() == Blocks.f_50057_.m_5456_() && !((ItemStack)this.f_58310_.get(1)).m_41619_() && ((ItemStack)this.f_58310_.get(1)).m_41720_() == Items.f_42446_) {
                this.f_58310_.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            rawStack.m_41774_(1);
        }
    }

    public int getBurnTime() {
        return this.f_58311_.m_6413_(0);
    }

    public int getRecipesUsed() {
        return this.f_58311_.m_6413_(1);
    }

    public int getCookTimeVar() {
        return this.f_58311_.m_6413_(2);
    }

    public int getCookTimeTotal() {
        return this.f_58311_.m_6413_(3);
    }

    public void setBurnTime(int value) {
        this.f_58311_.m_8050_(0, value);
    }

    public void setRecipesUsed(int value) {
        this.f_58311_.m_8050_(1, value);
    }

    public void setCookTimeVar(int value) {
        this.f_58311_.m_8050_(2, value);
    }

    public void setCookTimeTotal(int value) {
        this.f_58311_.m_8050_(3, value);
    }

    private boolean canBurn(@Nullable Recipe<?> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        if (!((ItemStack)items.get(0)).m_41619_() && recipe != null) {
            ItemStack itemstack = recipe.m_5874_((Container)this);
            if (itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)items.get(2);
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!itemstack1.m_41656_(itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= maxStackSize && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    public static boolean isFuel(ItemStack stack) {
        return BlueSkiesData.SNOWCAP_OVEN_FREEZING.getData().containsKey(stack.m_41720_());
    }

    public int[] m_7071_(Direction side) {
        int[] nArray;
        if (side == Direction.DOWN) {
            return new int[]{2, 3, 1};
        }
        if (side == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 2 || index == 3) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.f_58310_.get(1);
        return SnowcapOvenBlockEntity.isFuel(stack) || stack.m_41720_() == Items.f_42446_ && itemstack.m_41720_() != Items.f_42446_;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1 || !SnowcapOvenBlockEntity.isFuel(stack);
    }
}

