/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.IToJson;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class AlchemyRecipe
implements IToJson<AlchemyRecipe> {
    protected static final String OVERRIDE_KEY = "override";
    protected static final String TYPE_KEY = "type";
    public final boolean shouldOverride;
    public final ResourceLocation type;

    public AlchemyRecipe(boolean shouldOverride, ResourceLocation type) {
        this.shouldOverride = shouldOverride;
        this.type = type;
    }

    public abstract void mergeRecipe(AlchemyRecipe var1);

    public abstract List<Item> getResults(Item var1, Item var2);

    public abstract List<Item> getResults();

    public abstract List<ImmutableTriple<ItemStack, ItemStack, ItemStack>> getAllCombinations();

    public abstract boolean matches(Item var1, Item var2);

    public abstract AlchemyRecipe fromJson(JsonObject var1) throws SkiesDataManager.RegistryObjectNotFoundException;

    protected List<Item> toItemList(List<ResourceLocation> resourceLocationSet) {
        return resourceLocationSet.stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).collect(Collectors.toList());
    }

    @Nullable
    public AlchemyRecipe fromNbt(CompoundTag nbt) {
        try {
            return this.fromJson(((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt)).getAsJsonObject());
        }
        catch (Exception e) {
            SkiesDataManager.LOGGER.error("Failed to read an alchemy recipe from nbt {}");
            return null;
        }
    }

    public CompoundTag toNbt(AlchemyRecipe recipe) {
        if (this.getClass().isInstance(recipe)) {
            return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)this.toJson());
        }
        throw new IllegalArgumentException("The recipe passed was not an instanceof " + this.getClass().toString());
    }

    public static String getDirectory() {
        return "alchemy_recipes";
    }

    public static class Types {
        private static final Map<ResourceLocation, AlchemyRecipe> REGISTRY = new HashMap<ResourceLocation, AlchemyRecipe>();

        public static void register(AlchemyRecipe recipeDefault) {
            REGISTRY.put(recipeDefault.type, recipeDefault);
        }

        public static AlchemyRecipe parse(JsonObject json) {
            ResourceLocation name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)AlchemyRecipe.TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe parse(CompoundTag nbt) {
            ResourceLocation name = new ResourceLocation(nbt.m_128461_(AlchemyRecipe.TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe get(ResourceLocation name) {
            if (REGISTRY.containsKey(name)) {
                return REGISTRY.get(name);
            }
            IllegalArgumentException e = new IllegalArgumentException(name.toString() + " is not a registered recipe type!");
            BlueSkies.LOGGER.fatal((Object)e);
            throw e;
        }

        static {
            Types.register(new TransmuteRecipe(new ArrayList<ResourceLocation>(), new ArrayList<TagKey<Item>>(), new ArrayList<ResourceLocation>(), false));
            Types.register(new CatylistRecipe(Items.f_41852_, Items.f_41852_, new ArrayList<Item>(), false));
        }
    }
}

