/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;

public class SnowOwlEntity
extends SkiesAnimalEntity
implements FlyingAnimal {
    protected static final EntityDataAccessor<Boolean> HOSTILE = SynchedEntityData.m_135353_(SnowOwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public float nextFlap = 1.0f;
    public BlockPos exitPos = null;

    public SnowOwlEntity(EntityType<? extends SnowOwlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26440_(true);
        return flyingpathnavigator;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOSTILE, (Object)false);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setOwlHostile(compound.m_128471_("OwlHostile"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("OwlHostile", this.isOwlHostile());
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.6f;
    }

    public void m_8107_() {
        float speed;
        super.m_8107_();
        this.calculateFlapping();
        float f = speed = this.m_142592_() ? 3.0f : 1.0f;
        if (this.isOwlHostile() && this.exitPos != null && this.exitPos != BlockPos.f_121853_) {
            this.m_21573_().m_26519_((double)this.exitPos.m_123341_(), (double)this.exitPos.m_123342_(), (double)this.exitPos.m_123343_(), (double)speed);
            if (EntityUtil.getDistanceToPos((Vec3i)this.m_142538_(), (Vec3i)this.exitPos) < 2.0f) {
                this.exitPos = null;
            }
        } else if (this.m_5448_() != null) {
            if (!this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.m_21573_().m_5624_((Entity)this.m_5448_(), (double)speed);
            } else {
                this.m_21566_().m_6849_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_() + (double)this.m_5448_().m_20192_(), this.m_5448_().m_20189_(), (double)speed);
            }
        }
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.f_19861_ && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3d = this.m_20184_();
        if (!this.f_19861_ && vec3d.f_82480_ < 0.0) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_(SkiesSounds.ENTITY_SNOW_OWL_FLAP, 0.15f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public AgeableMob createChild(AgeableMob ageable) {
        return null;
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
    }

    public ResourceLocation m_7582_() {
        return this.isOwlHostile() ? BuiltInLootTables.f_78712_ : this.m_6095_().m_20677_();
    }

    public SoundEvent m_7515_() {
        if (this.isOwlHostile()) {
            return null;
        }
        return this.f_19796_.nextFloat() < 0.03f && BlueSkiesConfig.COMMON.isChristmas() ? SkiesSounds.ENTITY_SNOW_OWL_SING : SkiesSounds.ENTITY_SNOW_OWL_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SNOW_OWL_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SNOW_OWL_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12226_, 0.15f, 1.0f);
    }

    public float m_6100_() {
        return EntityUtil.getSoundPitchWithStart(this.f_19796_, 1.0f);
    }

    protected float m_6121_() {
        return this.isOwlHostile() ? 1.0f : 1.7f;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player) && !(entityIn instanceof EntWallEntity)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    public boolean isOwlHostile() {
        return (Boolean)this.f_19804_.m_135370_(HOSTILE);
    }

    public void setOwlHostile(boolean hostileIn) {
        if (hostileIn) {
            this.f_21364_ = 0;
            this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true){

                protected double m_6639_(LivingEntity attackTarget) {
                    return this.f_25540_.m_20205_() * 3.5f * this.f_25540_.m_20205_() * 3.5f + attackTarget.m_20205_();
                }
            });
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, StarlitCrusherEntity.class, 5.0f, 0.6, 1.0));
        } else {
            this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        }
        this.f_19804_.m_135381_(HOSTILE, (Object)hostileIn);
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.m_7307_((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.m_6095_().m_204039_(SkiesEntityTags.NATURE_ALLIES)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != null && entityIn != this;
    }

    public static boolean spawnConditions(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        BlockState block = world.m_8055_(pos.m_7495_());
        return (block.m_204336_(BlockTags.f_13035_) || block.m_204336_(BlockTags.f_13106_)) && world.m_45524_(pos, 0) > 8;
    }
}

