/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.codec.text;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.NbtComponent;
import net.minecraft.network.chat.ScoreComponent;
import net.minecraft.network.chat.SelectorComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public enum ComponentCodec implements Codec<Component>
{
    INSTANCE;


    private static <T> Either<String, String> getString(DynamicOps<T> ops, T value) {
        DataResult stringDataResult = ops.getStringValue(value);
        Optional error = stringDataResult.error();
        return error.map(stringPartialResult -> Either.right((Object)stringPartialResult.message())).orElseGet(() -> Either.left((Object)((String)stringDataResult.result().get())));
    }

    private static <T> boolean has(@Nonnull MapLike<T> mapLike, @Nonnull String key) {
        return mapLike.get(key) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> ops, T input) {
        Optional optional;
        DataResult stringDataResult = ops.getStringValue(input);
        if (!stringDataResult.error().isPresent()) {
            return DataResult.success((Object)Pair.of((Object)new TextComponent((String)stringDataResult.result().get()), input));
        }
        DataResult mapLikeDataResult = ops.getMap(input);
        if (!mapLikeDataResult.error().isPresent() && (optional = mapLikeDataResult.result()).isPresent()) {
            TextComponent formattableTextComponent;
            MapLike mapLike = (MapLike)optional.get();
            if (ComponentCodec.has(mapLike, "text")) {
                Either<String, String> textOrError = ComponentCodec.getString(ops, mapLike.get("text"));
                if (!textOrError.left().isPresent()) return DataResult.error((String)((String)textOrError.right().get()));
                formattableTextComponent = new TextComponent((String)textOrError.left().get());
            } else if (ComponentCodec.has(mapLike, "translate")) {
                Optional stringOptional = ops.getStringValue(mapLike.get("translate")).result();
                if (!stringOptional.isPresent()) return DataResult.error((String)"Missing 'translate', expected to find string");
                string = (String)stringOptional.get();
                if (ComponentCodec.has(mapLike, "with")) {
                    Optional withStream = ops.getStream(mapLike.get("with")).result();
                    if (!withStream.isPresent()) return DataResult.error((String)"Expected 'with' to be a JsonArray");
                    Stream stream = (Stream)withStream.get();
                    List list = stream.collect(Collectors.toList());
                    Object[] objects = new Object[list.size()];
                    for (int i = 0; i < objects.length; ++i) {
                        TextComponent stringTextComponent;
                        DataResult<Pair<Component, T>> dataResult = this.decode(ops, list.get(i));
                        Optional error = dataResult.error();
                        if (error.isPresent()) {
                            return DataResult.error((String)((DataResult.PartialResult)error.get()).message());
                        }
                        objects[i] = dataResult.result().get();
                        Object object = objects[i];
                        if (!(object instanceof TextComponent) || !(stringTextComponent = (TextComponent)object).m_7383_().m_131179_() || !stringTextComponent.m_7360_().isEmpty()) continue;
                        objects[i] = stringTextComponent.m_131292_();
                    }
                    formattableTextComponent = new TranslatableComponent(string, objects);
                } else {
                    formattableTextComponent = new TranslatableComponent(string);
                }
            } else if (ComponentCodec.has(mapLike, "score")) {
                Optional optionalScoreMap = ops.getMap(mapLike.get("score")).result();
                if (!optionalScoreMap.isPresent()) return DataResult.error((String)"Expected 'score' to be a JsonObject");
                MapLike scoreMap = (MapLike)optionalScoreMap.get();
                if (!ComponentCodec.has(scoreMap, "name") || !ComponentCodec.has(scoreMap, "objective")) {
                    return DataResult.error((String)"A score component needs at least a name and an objective");
                }
                Either<String, String> stringNameOrError = ComponentCodec.getString(ops, scoreMap.get("name"));
                if (stringNameOrError.right().isPresent()) {
                    return DataResult.error((String)((String)stringNameOrError.right().get()));
                }
                Either<String, String> errorOrStringObjective = ComponentCodec.getString(ops, scoreMap.get("objective"));
                if (errorOrStringObjective.right().isPresent()) {
                    return DataResult.error((String)((String)errorOrStringObjective.right().get()));
                }
                formattableTextComponent = new ScoreComponent((String)stringNameOrError.left().get(), (String)errorOrStringObjective.left().get());
            } else if (ComponentCodec.has(mapLike, "selector")) {
                selectorOrError = ComponentCodec.getString(ops, mapLike.get("selector"));
                if (!selectorOrError.left().isPresent()) return DataResult.error((String)((String)selectorOrError.right().get()));
                formattableTextComponent = new SelectorComponent((String)selectorOrError.left().get(), Optional.empty());
            } else if (ComponentCodec.has(mapLike, "keybind")) {
                selectorOrError = ComponentCodec.getString(ops, mapLike.get("keybind"));
                if (!selectorOrError.left().isPresent()) return DataResult.error((String)((String)selectorOrError.right().get()));
                formattableTextComponent = new KeybindComponent((String)selectorOrError.left().get());
            } else {
                if (!ComponentCodec.has(mapLike, "nbt")) {
                    return DataResult.error((String)("Don't know how to turn " + mapLike + " into a Component"));
                }
                Either<String, String> nbtOrError = ComponentCodec.getString(ops, mapLike.get("nbt"));
                if (!nbtOrError.left().isPresent()) return DataResult.error((String)((String)nbtOrError.right().get()));
                string = (String)nbtOrError.left().get();
                boolean interpret = ComponentCodec.has(mapLike, "interpret");
                if (interpret) {
                    DataResult interpretResult = ops.getBooleanValue(mapLike.get("interpret"));
                    if (interpretResult.error().isPresent()) {
                        return DataResult.error((String)"Expected 'interpret' to be a boolean");
                    }
                    interpret = (Boolean)interpretResult.result().get();
                }
                if (ComponentCodec.has(mapLike, "block")) {
                    Either<String, String> blockOrError = ComponentCodec.getString(ops, mapLike.get("block"));
                    if (!blockOrError.left().isPresent()) return DataResult.error((String)((String)blockOrError.right().get()));
                    formattableTextComponent = new NbtComponent.BlockNbtComponent(string, interpret, (String)blockOrError.left().get(), Optional.empty());
                } else if (ComponentCodec.has(mapLike, "entity")) {
                    Either<String, String> entityOrError = ComponentCodec.getString(ops, mapLike.get("entity"));
                    if (!entityOrError.left().isPresent()) return DataResult.error((String)((String)entityOrError.right().get()));
                    formattableTextComponent = new NbtComponent.EntityNbtComponent(string, interpret, (String)entityOrError.left().get(), Optional.empty());
                } else {
                    if (!ComponentCodec.has(mapLike, "storage")) {
                        return DataResult.error((String)("Don't know how to turn " + mapLike + " into a Component"));
                    }
                    Either<String, String> storageOrError = ComponentCodec.getString(ops, mapLike.get("storage"));
                    if (!storageOrError.left().isPresent()) return DataResult.error((String)((String)storageOrError.right().get()));
                    formattableTextComponent = new NbtComponent.StorageNbtComponent(string, interpret, new ResourceLocation((String)storageOrError.left().get()), Optional.empty());
                }
            }
            Object extra = mapLike.get("extra");
            if (extra == null) return DataResult.success((Object)Pair.of((Object)formattableTextComponent, input));
            DataResult extraResult = ops.getStream(extra);
            Optional error = extraResult.error();
            if (error.isPresent()) {
                return DataResult.error((String)((DataResult.PartialResult)error.get()).message());
            }
            Stream extraStream = (Stream)extraResult.result().get();
            List entries = extraStream.collect(Collectors.toList());
            if (entries.isEmpty()) {
                return DataResult.error((String)"Unexpected empty array of components");
            }
            for (Object entry : entries) {
                DataResult<Pair<Component, T>> entryResult = this.decode(ops, entry);
                Optional entryError = entryResult.error();
                if (entryError.isPresent()) {
                    return DataResult.error((String)((DataResult.PartialResult)entryError.get()).message());
                }
                formattableTextComponent.m_7220_((Component)((Pair)entryResult.result().get()).getFirst());
            }
            return DataResult.success((Object)Pair.of((Object)formattableTextComponent, input));
        }
        DataResult streamDataResult = ops.getStream(input);
        Optional error = streamDataResult.error();
        if (error.isPresent()) {
            return DataResult.error((String)("Don't know how to turn " + input + " into a Component"));
        }
        Optional stringOptional = streamDataResult.result();
        if (!stringOptional.isPresent()) return DataResult.error((String)("Don't know how to turn " + input + " into a Component"));
        MarkerTextComponent component = new MarkerTextComponent();
        for (Object entry : ((Stream)stringOptional.get()).collect(Collectors.toList())) {
            DataResult<Pair<Component, T>> entryResult = this.decode(ops, entry);
            Optional entryError = entryResult.error();
            if (entryError.isPresent()) {
                return DataResult.error((String)((DataResult.PartialResult)entryError.get()).message());
            }
            Optional optional2 = entryResult.result();
            if (!optional2.isPresent()) return DataResult.error((String)("No Component found in " + entry));
            if (component instanceof MarkerTextComponent) {
                component = (MutableComponent)((Pair)optional2.get()).getFirst();
                continue;
            }
            component.m_7220_((Component)((Pair)optional2.get()).getFirst());
        }
        return DataResult.success((Object)Pair.of((Object)((Object)component), input));
    }

    public <T> DataResult<T> encode(Component input, DynamicOps<T> ops, T prefix) {
        RecordBuilder mapBuilder = ops.mapBuilder();
        if (!input.m_7360_().isEmpty()) {
            ListBuilder siblings = ops.listBuilder();
            for (Component sibling : input.m_7360_()) {
                DataResult<Object> encodedSibling = this.encode(sibling, ops, ops.empty());
                if (encodedSibling.error().isPresent()) {
                    return DataResult.error((String)((DataResult.PartialResult)encodedSibling.error().get()).message());
                }
                siblings.add(encodedSibling);
            }
            mapBuilder.add("extra", siblings.build(ops.empty()));
        }
        if (input instanceof TextComponent) {
            mapBuilder.add("text", ops.createString(((TextComponent)input).m_131292_()));
        } else if (input instanceof TranslatableComponent) {
            TranslatableComponent translationTextComponent = (TranslatableComponent)input;
            mapBuilder.add("translate", ops.createString(((TranslatableComponent)input).m_131328_()));
            Object[] formatArgs = translationTextComponent.m_131329_();
            if (formatArgs != null && formatArgs.length > 0) {
                ListBuilder with = ops.listBuilder();
                for (Object arg : formatArgs) {
                    if (arg instanceof Component) {
                        DataResult<Object> encodedArg = this.encode((Component)arg, ops, ops.empty());
                        if (encodedArg.error().isPresent()) {
                            return DataResult.error((String)((DataResult.PartialResult)encodedArg.error().get()).message());
                        }
                        with.add(encodedArg);
                        continue;
                    }
                    with.add(ops.createString(String.valueOf(arg)));
                }
                mapBuilder.add("with", with.build(ops.empty()));
            }
        } else if (input instanceof ScoreComponent) {
            ScoreComponent scoreTextComponent = (ScoreComponent)input;
            RecordBuilder scoreMapBuilder = ops.mapBuilder();
            scoreMapBuilder.add("name", ops.createString(scoreTextComponent.m_131071_()));
            scoreMapBuilder.add("objective", ops.createString(scoreTextComponent.m_131072_()));
            mapBuilder.add("score", scoreMapBuilder.build(ops.empty()));
        } else if (input instanceof SelectorComponent) {
            mapBuilder.add("selector", ops.createString(((SelectorComponent)input).m_131096_()));
        } else if (input instanceof KeybindComponent) {
            mapBuilder.add("keybind", ops.createString(((KeybindComponent)input).m_130935_()));
        } else {
            if (!(input instanceof NbtComponent)) {
                return DataResult.error((String)("Don't know how to encode " + input + " as a Component"));
            }
            NbtComponent nbtTextComponent = (NbtComponent)input;
            mapBuilder.add("nbt", ops.createString(nbtTextComponent.m_130979_()));
            mapBuilder.add("interpret", ops.createBoolean(nbtTextComponent.m_130980_()));
            if (nbtTextComponent instanceof NbtComponent.BlockNbtComponent) {
                mapBuilder.add("block", ops.createString(((NbtComponent.BlockNbtComponent)nbtTextComponent).m_131001_()));
            } else if (nbtTextComponent instanceof NbtComponent.EntityNbtComponent) {
                mapBuilder.add("entity", ops.createString(((NbtComponent.EntityNbtComponent)nbtTextComponent).m_131024_()));
            } else {
                if (!(nbtTextComponent instanceof NbtComponent.StorageNbtComponent)) {
                    return DataResult.error((String)("Don't know to encode " + nbtTextComponent + " as a Component"));
                }
                mapBuilder.add("storage", ops.createString(((NbtComponent.StorageNbtComponent)nbtTextComponent).m_131043_().toString()));
            }
        }
        return mapBuilder.build(prefix);
    }

    static class MarkerTextComponent
    extends TextComponent {
        public MarkerTextComponent() {
            super("");
        }
    }
}

