/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.ai.BigFireballAttackGoal;
import com.brutalbosses.entity.ai.ChargeGoal;
import com.brutalbosses.entity.ai.ChasingGoal;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.ItemThrowAttackGoal;
import com.brutalbosses.entity.ai.LavaRescueGoal;
import com.brutalbosses.entity.ai.MeleeHitGoal;
import com.brutalbosses.entity.ai.MeleeShieldAttackGoal;
import com.brutalbosses.entity.ai.OutofCombatRegen;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.ai.SmallFireballAttackGoal;
import com.brutalbosses.entity.ai.SnowballAttackGoal;
import com.brutalbosses.entity.ai.SpitCobwebGoal;
import com.brutalbosses.entity.ai.SummonMobsGoal;
import com.brutalbosses.entity.ai.TemporaryPotionGoal;
import com.brutalbosses.entity.ai.WhirlWind;
import com.brutalbosses.entity.ai.WitherSkullAttackGoal;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;

public class BossTypeManager {
    public Map<ResourceLocation, BossType> bosses = ImmutableMap.of();
    public Set<ResourceLocation> entityTypes = ImmutableSet.of();
    public static final BossTypeManager instance = new BossTypeManager();
    public Map<ResourceLocation, BiConsumer<Entity, IAIParams>> aiCreatorRegistry = ImmutableMap.of();
    public Map<ResourceLocation, Function<JsonObject, IAIParams>> aiParamParsers = ImmutableMap.of();
    public ImmutableMap<ResourceLocation, List<BossType>> lootTableSpawnEntries = ImmutableMap.of();

    private BossTypeManager() {
        this.registerAI(new ResourceLocation("minecraft:randomwalk"), (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new RandomStrollGoal((PathfinderMob)entity, 0.8, 20)), null);
        this.registerAI(new ResourceLocation("minecraft:meleeattack"), (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new MeleeAttackGoal((PathfinderMob)entity, 1.0, true)), null);
        this.registerAI(new ResourceLocation("minecraft:crossbow"), (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new RangedCrossbowAttackGoal((Monster)((CrossbowAttackMob)((RangedAttackMob)entity)), 1.0, 30.0f)), null);
        this.registerAI(MeleeShieldAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2001, (Goal)new MeleeShieldAttackGoal((Mob)entity, 1.0)), null);
        this.registerAI(new ResourceLocation("minecraft:target"), (entity, params) -> ((Mob)entity).f_21346_.m_25352_(-2000, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, true)), null);
        this.registerAI(LavaRescueGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new LavaRescueGoal((Mob)entity)), null);
        this.registerAI(ChasingGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2001, (Goal)new ChasingGoal((Mob)entity, (IAIParams)params)), ChasingGoal.ChaseParams::new);
        this.registerAI(SmallFireballAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new SmallFireballAttackGoal((Mob)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(WitherSkullAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new WitherSkullAttackGoal((Mob)entity, (IAIParams)params)), WitherSkullAttackGoal.WitherSkullParams::new);
        this.registerAI(SnowballAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new SnowballAttackGoal((Mob)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(OutofCombatRegen.ID, (entity, params) -> ((Mob)entity).f_21346_.m_25352_(-2000, (Goal)new OutofCombatRegen((Mob)entity, (IAIParams)params)), OutofCombatRegen.CombatParams::new);
        this.registerAI(SpitCobwebGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new SpitCobwebGoal((Mob)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(SummonMobsGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new SummonMobsGoal((Mob)entity, (IAIParams)params)), SummonMobsGoal.SummonParams::new);
        this.registerAI(WhirlWind.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new WhirlWind((Mob)entity, (IAIParams)params)), WhirlWind.WhirldWindParams::new);
        this.registerAI(new ResourceLocation("brutalbosses:whirldwind"), (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new WhirlWind((Mob)entity, (IAIParams)params)), WhirlWind.WhirldWindParams::new);
        this.registerAI(MeleeHitGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new MeleeHitGoal((Mob)entity, (IAIParams)params)), MeleeHitGoal.MeleeHitParams::new);
        this.registerAI(ChargeGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new ChargeGoal((Mob)entity, (IAIParams)params)), ChargeGoal.ChargeParams::new);
        this.registerAI(BigFireballAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new BigFireballAttackGoal((Mob)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(ItemThrowAttackGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new ItemThrowAttackGoal((Mob)entity, (IAIParams)params)), ItemThrowAttackGoal.ItemThrowParams::new);
        this.registerAI(TemporaryPotionGoal.ID, (entity, params) -> ((Mob)entity).f_21345_.m_25352_(-2000, (Goal)new TemporaryPotionGoal((Mob)entity, (IAIParams)params)), TemporaryPotionGoal.TempPotionParams::new);
    }

    public void registerAI(ResourceLocation ID, BiConsumer<Entity, IAIParams> aiCreator, @Nullable Function<JsonObject, IAIParams> paramsParser) {
        ImmutableMap.Builder aiRegistry = ImmutableMap.builder();
        ImmutableMap.Builder aiSupplier = ImmutableMap.builder();
        aiRegistry.putAll(this.aiCreatorRegistry);
        aiSupplier.putAll(this.aiParamParsers);
        aiRegistry.put((Object)ID, aiCreator);
        if (paramsParser != null) {
            aiSupplier.put((Object)ID, paramsParser);
        }
        for (int i = 1; i < 5; ++i) {
            ResourceLocation additionalID = new ResourceLocation(ID.m_135827_(), ID.m_135815_() + i);
            aiRegistry.put((Object)additionalID, aiCreator);
            if (paramsParser == null) continue;
            aiSupplier.put((Object)additionalID, paramsParser);
        }
        this.aiCreatorRegistry = aiRegistry.build();
        this.aiParamParsers = aiSupplier.build();
    }

    public void afterLoad() {
        ImmutableSet.Builder entityTypes = ImmutableSet.builder();
        HashMap<ResourceLocation, List> tempSpawns = new HashMap<ResourceLocation, List>();
        for (BossType bossType : this.bosses.values()) {
            entityTypes.add((Object)bossType.getEntityType().getRegistryName());
            BrutalBosses.LOGGER.info("Loaded boss variant for: " + bossType.getEntityType().getRegistryName());
            for (Map.Entry spawnEntry : bossType.getSpawnTables().entrySet()) {
                List contained = tempSpawns.computeIfAbsent((ResourceLocation)spawnEntry.getKey(), loc -> new ArrayList());
                for (int i = 0; i < (Integer)spawnEntry.getValue(); ++i) {
                    contained.add(bossType);
                }
            }
        }
        this.entityTypes = entityTypes.build();
        ImmutableMap.Builder spawnMap = ImmutableMap.builder();
        for (Map.Entry entry : tempSpawns.entrySet()) {
            ImmutableList.Builder bossList = ImmutableList.builder();
            bossList.addAll((Iterable)entry.getValue());
            spawnMap.put((Object)((ResourceLocation)entry.getKey()), (Object)bossList.build());
        }
        this.lootTableSpawnEntries = spawnMap.build();
    }

    public void register(RegisterCapabilitiesEvent event) {
        event.register(BossCapability.class);
    }

    public boolean isValidBossEntity(Entity entity) {
        return this.entityTypes.contains(entity.m_6095_().getRegistryName());
    }

    public void setBossTypes(ImmutableMap<ResourceLocation, BossType> bossTypes) {
        this.bosses = bossTypes;
    }
}

