/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ModEntities;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class TemporaryPotionGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:temppotions");
    private final Mob mob;
    private TempPotionParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;

    public TemporaryPotionGoal(Mob mob, IAIParams params) {
        this.params = (TempPotionParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
        for (Tuple<MobEffect, Integer> potion : this.params.potions) {
            MobEffectInstance MobEffectInstance2 = this.mob.m_21124_((MobEffect)potion.m_14418_());
            if (MobEffectInstance2 == null || MobEffectInstance2.m_19557_() >= this.params.duration) continue;
            this.mob.m_21195_((MobEffect)potion.m_14418_());
        }
    }

    public void m_8037_() {
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        this.ticksToNextUpdate = (int)this.params.interval;
        for (Tuple<MobEffect, Integer> potion : this.params.potions) {
            this.mob.m_7292_(new MobEffectInstance((MobEffect)potion.m_14418_(), this.params.duration, ((Integer)potion.m_14419_()).intValue()));
        }
        if (this.params.item != null) {
            ThrownItemEntity item = (ThrownItemEntity)ModEntities.THROWN_ITEMC.m_20615_(this.mob.f_19853_);
            item.m_6034_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
            this.mob.f_19853_.m_7967_((Entity)item);
            item.m_7998_((Entity)this.mob, true);
            ((IOnProjectileHit)((Object)item)).setMaxLifeTime(this.mob.f_19853_.m_46467_() + (long)this.params.duration);
            item.m_37446_(this.params.item);
            item.setScale(this.params.visibleitemsize);
        }
        this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12586_, this.mob.m_5720_(), 1.0f, 1.0f);
        double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
        double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
        if (this.mob.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 20, d0, 0.0, d1, 0.0);
        }
    }

    public static class TempPotionParams
    extends IAIParams.DefaultParams {
        private int duration = 100;
        private float interval = 200.0f;
        private List<Tuple<MobEffect, Integer>> potions = new ArrayList<Tuple<MobEffect, Integer>>();
        private ItemStack item = null;
        private float visibleitemsize = 2.0f;
        public static final String POTION_DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String ITEM = "visibleitem";
        public static final String ITEMSIZE = "visibleitemsize";

        public TempPotionParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(POTION_DURATION)) {
                this.duration = jsonElement.get(POTION_DURATION).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(ITEMSIZE)) {
                this.visibleitemsize = jsonElement.get(ITEMSIZE).getAsFloat();
            }
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)jsonElement.get(ITEM).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                    throw new UnsupportedOperationException();
                }
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<Tuple<MobEffect, Integer>>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    this.potions.add((Tuple<MobEffect, Integer>)new Tuple((Object)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)((String)data.getKey())))), (Object)((JsonElement)data.getValue()).getAsInt()));
                }
            }
            return this;
        }
    }
}

