/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class WhirlWind
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:whirlwind");
    private final Mob mob;
    private LivingEntity target = null;
    private WhirldWindParams params;
    private int attackTimer = 0;

    public WhirlWind(Mob mob, IAIParams params) {
        this.params = (WhirldWindParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void m_8037_() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        if (distSqr < (double)(this.params.attackDistance * this.params.attackDistance) && BrutalBosses.rand.nextInt(40) == 0) {
            this.attackTimer = this.params.cooldown;
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>(this.mob.f_19853_.m_45976_(Player.class, this.mob.m_142469_().m_82377_(2.0, 0.5, 2.0)));
            if (!entities.contains(this.target)) {
                entities.add(this.target);
            }
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.mob || livingentity == null || !livingentity.m_6084_()) continue;
                if (this.params.knockup) {
                    livingentity.m_20256_(livingentity.m_20184_().m_82520_(0.0, (double)(this.params.knockback / 5.0f), 0.0));
                } else {
                    livingentity.m_147240_((double)this.params.knockback, (double)Mth.m_14031_((float)(livingentity.m_146908_() * (float)Math.PI)), (double)(-Mth.m_14089_((float)(livingentity.m_146908_() * (float)Math.PI))));
                }
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                float damage = this.params.extraDamage;
                if (this.mob.m_21204_().m_22171_(Attributes.f_22281_)) {
                    damage = (float)((double)damage + this.mob.m_21133_(Attributes.f_22281_));
                }
                livingentity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), damage);
                if (this.params.onHitMobEffect == null) continue;
                livingentity.m_7292_(new MobEffectInstance(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
            }
            this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12317_, this.mob.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            if (this.mob.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 2, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class WhirldWindParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 4.0f;
        private float extraDamage = 2.0f;
        private MobEffect onHitMobEffect = null;
        private float knockback = 4.0f;
        private int cooldown = 80;
        private int potionlevel = 1;
        private int potionduration = 60;
        private boolean knockup = false;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "extradamage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";
        private static final String KNOCK_UP = "knockup";

        public WhirldWindParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(KNOCK_UP)) {
                this.knockup = jsonElement.get(KNOCK_UP).getAsBoolean();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation MobEffectID = new ResourceLocation(jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(MobEffectID);
            }
            return this;
        }
    }
}

