/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BossCapMessage
implements IMessage {
    BossCapability cap = null;
    private int entityID = -1;
    private CompoundTag nbt = null;

    public BossCapMessage(BossCapability cap) {
        this.cap = cap;
    }

    public BossCapMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cap.getEntity().m_142049_());
        buffer.m_130079_(this.cap.serializeNBT());
    }

    @Override
    public BossCapMessage read(FriendlyByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.nbt = buffer.m_130260_();
        return this;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss capability message sent to the wrong side!", (Throwable)new Exception());
        } else {
            Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(this.entityID);
            if (entity != null) {
                ((BossCapability)entity.getCapability(BossCapability.BOSS_CAP).orElse(null)).deserializeNBT((Tag)this.nbt);
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

