/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.network;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.network.IMessage;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class BossTypeSyncMessage
implements IMessage {
    private Collection<BossType> bossTypes = new HashSet<BossType>();

    public BossTypeSyncMessage(Collection<BossType> values) {
        this.bossTypes = values;
    }

    public BossTypeSyncMessage() {
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bossTypes.size());
        for (BossType type : this.bossTypes) {
            buffer.m_130079_(type.serializeToClient());
        }
    }

    @Override
    public BossTypeSyncMessage read(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        this.bossTypes = new ArrayList<BossType>();
        for (int i = 0; i < count; ++i) {
            BossType type = BossType.deserializeAtClient(buffer.m_130260_());
            if (type == null) continue;
            this.bossTypes.add(type);
        }
        return this;
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            BrutalBosses.LOGGER.error("Boss capability message sent to the wrong side!", (Throwable)new Exception());
        } else {
            ImmutableMap.Builder bossTypesImm = ImmutableMap.builder();
            for (BossType type : this.bossTypes) {
                bossTypesImm.put((Object)type.getID(), (Object)type);
            }
            BossTypeManager.instance.bosses = bossTypesImm.build();
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

