/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix.core;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;

public abstract class AffixData {
    private IChampion champion;
    private String identifier;

    protected AffixData() {
    }

    public void readData(IChampion champion, String identifier) {
        this.champion = champion;
        this.identifier = identifier;
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = !livingEntity.m_183503_().m_5776_() ? champion.getServer().getData(identifier) : champion.getClient().getData(identifier);
        this.readFromNBT(tag);
    }

    public abstract void readFromNBT(CompoundTag var1);

    public abstract CompoundTag writeToNBT();

    public void saveData() {
        LivingEntity livingEntity = this.champion.getLivingEntity();
        if (!livingEntity.m_183503_().m_5776_()) {
            this.champion.getServer().setData(this.identifier, this.writeToNBT());
        } else {
            this.champion.getClient().setData(this.identifier, this.writeToNBT());
        }
    }

    public static <T extends AffixData> T getData(IChampion champion, String id, Class<T> clazz) {
        AffixData data = null;
        try {
            data = (AffixData)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            data.readData(champion, id);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Champions.LOGGER.error("Error reading data from class " + clazz);
        }
        return (T)data;
    }

    public static class IntegerData
    extends AffixData {
        public int num;

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.num = tag.m_128451_("num");
        }

        @Override
        public CompoundTag writeToNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("num", this.num);
            return compound;
        }
    }

    public static class BooleanData
    extends AffixData {
        public boolean mode;

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.mode = tag.m_128471_("mode");
        }

        @Override
        public CompoundTag writeToNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("mode", this.mode);
            return compound;
        }
    }
}

