/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.integration.gamestages.GameStagesPlugin;
import top.theillusivec4.champions.common.integration.scalinghealth.ScalingHealthPlugin;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionData;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;

public class ChampionBuilder {
    private static final Random RAND = new Random();

    public static void spawn(IChampion champion) {
        if (ChampionData.read(champion)) {
            return;
        }
        LivingEntity entity = champion.getLivingEntity();
        Rank newRank = ChampionBuilder.createRank(entity);
        champion.getServer().setRank(newRank);
        ChampionBuilder.applyGrowth(entity, newRank.getGrowthFactor());
        List<IAffix> newAffixes = ChampionBuilder.createAffixes(newRank, champion);
        champion.getServer().setAffixes(newAffixes);
        newAffixes.forEach(affix -> affix.onInitialSpawn(champion));
    }

    public static void spawnPreset(IChampion champion, int tier, List<IAffix> affixes) {
        LivingEntity entity = champion.getLivingEntity();
        Rank newRank = RankManager.getRank(tier);
        champion.getServer().setRank(newRank);
        ChampionBuilder.applyGrowth(entity, newRank.getGrowthFactor());
        affixes = affixes.isEmpty() ? ChampionBuilder.createAffixes(newRank, champion) : affixes;
        champion.getServer().setAffixes(affixes);
        affixes.forEach(affix -> affix.onInitialSpawn(champion));
    }

    public static List<IAffix> createAffixes(Rank rank, IChampion champion) {
        int size = rank.getNumAffixes();
        ArrayList<IAffix> affixesToAdd = new ArrayList<IAffix>();
        Optional<EntityManager.EntitySettings> entitySettings = EntityManager.getSettings(champion.getLivingEntity().m_6095_());
        if (size > 0) {
            entitySettings.ifPresent(settings -> {
                if (settings.presetAffixes != null) {
                    affixesToAdd.addAll(settings.presetAffixes);
                }
            });
            rank.getPresetAffixes().forEach(affix -> {
                if (!affixesToAdd.contains(affix)) {
                    affixesToAdd.add((IAffix)affix);
                }
            });
        }
        Map<AffixCategory, List<IAffix>> allAffixes = Champions.API.getCategoryMap();
        HashMap<AffixCategory, List> validAffixes = new HashMap<AffixCategory, List>();
        for (AffixCategory category : Champions.API.getCategories()) {
            validAffixes.put(category, new ArrayList());
        }
        allAffixes.forEach((k, v) -> ((List)validAffixes.get(k)).addAll(v.stream().filter(affix -> {
            Optional<AffixManager.AffixSettings> settings = AffixManager.getSettings(affix.getIdentifier());
            return !affixesToAdd.contains(affix) && entitySettings.map(entitySettings1 -> entitySettings1.canApply((IAffix)affix)).orElse(true) != false && settings.map(affixSettings -> affixSettings.canApply(champion)).orElse(true) != false && affix.canApply(champion);
        }).collect(Collectors.toList())));
        ArrayList randomList = new ArrayList();
        validAffixes.forEach((k, v) -> randomList.addAll(v));
        while (randomList.size() > 0 && affixesToAdd.size() < size) {
            int randomIndex = RAND.nextInt(randomList.size());
            IAffix randomAffix = (IAffix)randomList.get(randomIndex);
            if (affixesToAdd.stream().allMatch(affix -> affix.isCompatible(randomAffix) && (randomAffix.getCategory() == AffixCategory.OFFENSE || affix.getCategory() != randomAffix.getCategory()))) {
                affixesToAdd.add(randomAffix);
            }
            randomList.remove(randomIndex);
        }
        return affixesToAdd;
    }

    public static Rank createRank(LivingEntity livingEntity) {
        if (!ChampionHelper.checkPotential(livingEntity)) {
            return RankManager.getLowestRank();
        }
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        if (ranks.isEmpty()) {
            Champions.LOGGER.error("No rank configuration found! Please check the 'champions-ranks.toml' file in the 'serverconfigs'.");
            return RankManager.getLowestRank();
        }
        Integer[] tierRange = new Integer[]{null, null};
        EntityManager.getSettings(livingEntity.m_6095_()).ifPresent(entitySettings -> {
            tierRange[0] = entitySettings.minTier;
            tierRange[1] = entitySettings.maxTier;
        });
        Integer firstTier = tierRange[0] != null ? tierRange[0] : (Integer)ranks.firstKey();
        int maxTier = tierRange[1] != null ? tierRange[1] : -1;
        UnmodifiableIterator iter = ranks.navigableKeySet().tailSet((Object)firstTier, false).iterator();
        Rank result = (Rank)ranks.get((Object)firstTier);
        if (result == null) {
            Champions.LOGGER.error("Tier {} cannot be found in {}! Assigning lowest available rank to {}", (Object)firstTier, ranks, (Object)livingEntity);
            return RankManager.getLowestRank();
        }
        while (iter.hasNext() && (result.getTier() < maxTier || maxTier == -1)) {
            Rank rank = (Rank)ranks.get(iter.next());
            if (rank == null) {
                return result;
            }
            float chance = rank.getChance();
            if (Champions.scalingHealthLoaded) {
                chance = (float)((double)chance + ScalingHealthPlugin.getSpawnIncrease(rank.getTier(), livingEntity));
            }
            if (RAND.nextFloat() < chance && (!Champions.gameStagesLoaded || GameStagesPlugin.hasTierStage(rank.getTier(), livingEntity))) {
                result = rank;
                continue;
            }
            return result;
        }
        return result;
    }

    public static void applyGrowth(LivingEntity livingEntity, float growthFactor) {
        if (growthFactor < 1.0f) {
            return;
        }
        ChampionBuilder.grow(livingEntity, Attributes.f_22276_, ChampionsConfig.healthGrowth * (double)growthFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
        livingEntity.m_21153_(livingEntity.m_21233_());
        ChampionBuilder.grow(livingEntity, Attributes.f_22281_, ChampionsConfig.attackGrowth * (double)growthFactor, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ChampionBuilder.grow(livingEntity, Attributes.f_22284_, ChampionsConfig.armorGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
        ChampionBuilder.grow(livingEntity, Attributes.f_22285_, ChampionsConfig.toughnessGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
        ChampionBuilder.grow(livingEntity, Attributes.f_22278_, ChampionsConfig.knockbackResistanceGrowth * (double)growthFactor, AttributeModifier.Operation.ADDITION);
    }

    private static void grow(LivingEntity livingEntity, Attribute attribute, double amount, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
        if (attributeInstance != null) {
            double oldMax = attributeInstance.m_22115_();
            double newMax = switch (operation) {
                default -> throw new IncompatibleClassChangeError();
                case AttributeModifier.Operation.ADDITION -> oldMax + amount;
                case AttributeModifier.Operation.MULTIPLY_BASE -> oldMax * amount;
                case AttributeModifier.Operation.MULTIPLY_TOTAL -> oldMax * (1.0 + amount);
            };
            attributeInstance.m_22100_(newMax);
        }
    }

    public static void copy(IChampion oldChampion, IChampion newChampion) {
        IChampion.Server oldServer = oldChampion.getServer();
        IChampion.Server newServer = newChampion.getServer();
        Rank rank = oldServer.getRank().orElse(RankManager.getLowestRank());
        newServer.setRank(rank);
        ChampionBuilder.applyGrowth(newChampion.getLivingEntity(), rank.getGrowthFactor());
        List<IAffix> oldAffixes = oldChampion.getServer().getAffixes();
        newServer.setAffixes(oldAffixes);
        oldAffixes.forEach(affix -> affix.onInitialSpawn(newChampion));
    }
}

