/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.events;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.data.providers.DPAdvancementProv;
import com.legacy.dungeons_plus.data.providers.DPLangProvider;
import com.legacy.dungeons_plus.data.providers.DPLootProv;
import com.legacy.dungeons_plus.data.providers.DPTagProv;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.entity.EntityAccessHelper;
import com.legacy.structure_gel.api.events.RegisterLootTableAliasEvent;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class DPCommonEvents {

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        protected static void commonInit(FMLCommonSetupEvent event) {
            ModList modList = ModList.get();
            DungeonsPlus.isWaystonesLoaded = modList.isLoaded("waystones");
        }

        @SubscribeEvent
        protected static void registerLootTableAlias(RegisterLootTableAliasEvent event) {
            event.register(DungeonsPlus.locate("tower/common"), DPLoot.Tower.CHEST_COMMON);
            event.register(DungeonsPlus.locate("tower/barrel"), DPLoot.Tower.CHEST_BARREL);
            event.register(DungeonsPlus.locate("tower/vex"), DPLoot.Tower.CHEST_VEX);
            event.register(DungeonsPlus.locate("tower/vex_map"), DPLoot.Tower.CHEST_VEX_MAP);
            event.register(DungeonsPlus.locate("tower/skeleton"), DPLoot.Tower.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("tower/spider"), DPLoot.Tower.ENTITY_SPIDER);
            event.register(DungeonsPlus.locate("tower/zombie"), DPLoot.Tower.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("reanimated_ruins/common"), DPLoot.ReanimatedRuins.CHEST_COMMON);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert"), DPLoot.ReanimatedRuins.CHEST_DESERT);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert_map"), DPLoot.ReanimatedRuins.CHEST_DESERT_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen"), DPLoot.ReanimatedRuins.CHEST_FROZEN);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen_map"), DPLoot.ReanimatedRuins.CHEST_FROZEN_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy"), DPLoot.ReanimatedRuins.CHEST_MOSSY);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy_map"), DPLoot.ReanimatedRuins.CHEST_MOSSY_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/skeleton"), DPLoot.ReanimatedRuins.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("reanimated_ruins/zombie"), DPLoot.ReanimatedRuins.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("leviathan/common"), DPLoot.Leviathan.CHEST_COMMON);
            event.register(DungeonsPlus.locate("leviathan/rare"), DPLoot.Leviathan.CHEST_RARE);
            event.register(DungeonsPlus.locate("leviathan/husk"), DPLoot.Leviathan.ENTITY_HUSK);
            event.register(DungeonsPlus.locate("snowy_temple/common"), DPLoot.SnowyTemple.CHEST_COMMON);
            event.register(DungeonsPlus.locate("snowy_temple/rare"), DPLoot.SnowyTemple.CHEST_RARE);
            event.register(DungeonsPlus.locate("snowy_temple/stray"), DPLoot.SnowyTemple.ENTITY_STRAY);
            event.register(DungeonsPlus.locate("warped_garden/common"), DPLoot.WarpedGarden.CHEST_COMMON);
            event.register(DungeonsPlus.locate("warped_garden/rare"), DPLoot.WarpedGarden.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/common"), DPLoot.SoulPrison.CHEST_COMMON);
            event.register(DungeonsPlus.locate("soul_prison/rare"), DPLoot.SoulPrison.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/golden_armor"), DPLoot.SoulPrison.CHEST_GOLDEN_ARMOR);
        }

        @SubscribeEvent
        protected static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            DPTagProv.BlockProv blockTagProv = new DPTagProv.BlockProv(gen, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockTagProv);
            gen.m_123914_((DataProvider)new DPTagProv.ItemProv(gen, blockTagProv, existingFileHelper));
            gen.m_123914_((DataProvider)new DPTagProv.ConfiguredStructureFeatureProv(gen, existingFileHelper));
            gen.m_123914_((DataProvider)new DPTagProv.BiomeProv(gen, existingFileHelper));
            gen.m_123914_((DataProvider)new DPAdvancementProv(gen));
            gen.m_123914_((DataProvider)new DPLootProv(gen));
            gen.m_123914_((DataProvider)new DPLangProvider(gen));
        }
    }

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBus {
        public static void onEntitySpawn(Mob entity) {
            Level level = entity.m_183503_();
            if (!level.f_46443_) {
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20458_, DPStructures.LEVIATHAN, e -> {
                    Random rand;
                    if (((Boolean)DPConfig.COMMON.husksDropSand.get()).booleanValue()) {
                        EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.Leviathan.ENTITY_HUSK);
                    }
                    if ((rand = e.m_21187_()).nextFloat() < (float)((Integer)DPConfig.COMMON.huskLeviathanBladeChance.get()).intValue() / 100.0f) {
                        ItemStack stack = ((Item)DPItems.LEVIATHAN_BLADE.get()).m_7968_();
                        stack.m_41721_(rand.nextInt(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.MAINHAND, stack);
                        e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                    }
                });
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20481_, DPStructures.SNOWY_TEMPLE, e -> {
                    Random rand;
                    if (((Boolean)DPConfig.COMMON.straysDropIce.get()).booleanValue()) {
                        EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.SnowyTemple.ENTITY_STRAY);
                    }
                    if ((rand = e.m_21187_()).nextFloat() < (float)((Integer)DPConfig.COMMON.strayFrostedCowlChance.get()).intValue() / 100.0f) {
                        ItemStack stack = ((Item)DPItems.FROSTED_COWL.get()).m_7968_();
                        stack.m_41721_(rand.nextInt(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.HEAD, stack);
                        e.m_21409_(EquipmentSlot.HEAD, 0.12f);
                    }
                });
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20562_, DPStructures.WARPED_GARDEN, e -> {
                    Optional opTag;
                    Random rand = e.m_21187_();
                    if (rand.nextFloat() < (float)((Integer)DPConfig.COMMON.drownedWarpedAxeChance.get()).intValue() / 100.0f) {
                        ItemStack stack = ((Item)DPItems.WARPED_AXE.get()).m_7968_();
                        stack.m_41721_(rand.nextInt(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.MAINHAND, stack);
                        e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                    }
                    if (rand.nextFloat() < (float)((Integer)DPConfig.COMMON.drownedCoralChance.get()).intValue() / 100.0f && (opTag = level.m_5962_().m_175515_(Registry.f_122901_).m_203431_(BlockTags.f_13051_)).isPresent() && ((HolderSet.Named)opTag.get()).m_203632_() > 0) {
                        e.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)((Holder)((HolderSet.Named)opTag.get()).m_203450_(rand).get()).m_203334_()));
                        e.m_21409_(EquipmentSlot.OFFHAND, 1.0f);
                    }
                });
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20524_, DPStructures.SOUL_PRISON, e -> {
                    Random rand = e.m_21187_();
                    if (rand.nextFloat() < (float)((Integer)DPConfig.COMMON.skeletonSoulCannonChance.get()).intValue() / 100.0f) {
                        ItemStack stack = ((Item)DPItems.SOUL_CANNON.get()).m_7968_();
                        stack.m_41721_(rand.nextInt(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.OFFHAND, stack);
                        e.m_21409_(EquipmentSlot.OFFHAND, 0.3f);
                    }
                });
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20453_, DPStructures.SOUL_PRISON, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
                ForgeBus.ifInStructure((Entity)entity, EntityType.f_20566_, DPStructures.END_RUINS, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
            }
        }

        private static <T extends Entity> void ifInStructure(Entity entity, EntityType<T> entityTest, StructureRegistrar<?, ?> structure, Consumer<T> consumer) {
            ServerLevel serverLevel;
            Level level;
            if (entity.m_6095_().equals(entityTest) && (level = entity.f_19853_) instanceof ServerLevel && StructureAccessHelper.isInStructurePiece((ServerLevel)(serverLevel = (ServerLevel)level), (StructureFeature)structure.getStructure(), (BlockPos)entity.m_142538_())) {
                consumer.accept(entity);
            }
        }

        @SubscribeEvent
        protected static void onEffectApply(PotionEvent.PotionApplicableEvent event) {
            if (event.getPotionEffect().m_19544_() == MobEffects.f_19597_) {
                LivingEntity armor;
                ArrayList<ItemStack> strayArmors = new ArrayList<ItemStack>(1);
                for (ItemStack stack : event.getEntityLiving().m_6168_()) {
                    Item item = stack.m_41720_();
                    if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != DPItems.DPArmors.STRAY) continue;
                    strayArmors.add(stack);
                }
                int size = strayArmors.size();
                if (size > 0) {
                    event.setResult(Event.Result.DENY);
                    armor = event.getEntityLiving();
                    if (armor instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)armor;
                        Random rand = serverPlayer.m_21187_();
                        ((ItemStack)strayArmors.get(rand.nextInt(size))).m_41629_(2, rand, serverPlayer);
                    }
                }
            }
        }
    }
}

