/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.end_ruins;

import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelConfigJigsawStructure;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class EndRuinsStructure
extends GelConfigJigsawStructure<JigsawConfiguration> {
    public EndRuinsStructure(Codec<JigsawConfiguration> codec, StructureConfig config) {
        super(codec, config, 0, true, true, EndRuinsStructure::isValidHeight, Piece::new);
    }

    public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, IPieceBuilderModifier.Context<JigsawConfiguration> context) {
        List pieces = IPieceBuilderModifier.getPieces((StructurePiecesBuilder)pieceBuilder);
        pieces.removeIf(p -> {
            BoundingBox bounds = p.m_73547_();
            if (bounds.m_162396_() < 20) {
                return true;
            }
            int[] zs = new int[]{bounds.m_162398_(), bounds.m_162401_()};
            for (int x : new int[]{bounds.m_162395_(), bounds.m_162399_()}) {
                for (int z : zs) {
                    if (context.chunkGen().m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.level()) >= 20) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public int getSpacing() {
        return 27;
    }

    public int getOffset() {
        return this.getSpacing();
    }

    private static boolean isValidHeight(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int[] xz;
        ChunkPos chunkPos = context.f_197355_();
        for (int x : xz = new int[]{-8, 8}) {
            for (int z : xz) {
                if (context.f_197352_().m_156179_(chunkPos.m_151382_(x), chunkPos.m_151391_(z), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()) >= 56) continue;
                return false;
            }
        }
        return true;
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(StructureManager template, StructurePoolElement piece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(template, piece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(context, tag);
        }

        public StructurePieceType m_210000_() {
            return DPStructures.END_RUINS.getPieceType();
        }

        public void m_192416_(WorldGenLevel level, StructureFeatureManager structureManager, ChunkGenerator chunkGen, Random rand, BoundingBox bounds, BlockPos pos, boolean isLegacy) {
            if (pos.m_123342_() > 5) {
                super.m_192416_(level, structureManager, chunkGen, rand, bounds, pos, isLegacy);
                String name = this.getLocation().toString();
                if (name.contains("end_ruins/tower/base_")) {
                    this.extendDown((LevelAccessor)level, Blocks.f_50259_.m_49966_(), bounds, this.f_72599_, rand);
                }
            }
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
        }
    }
}

