/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.tower;

import com.legacy.dungeons_plus.structures.tower.TowerPieces;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelConfigStructure;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class TowerStructure
extends GelConfigStructure<NoneFeatureConfiguration> {
    public TowerStructure(Codec<NoneFeatureConfiguration> codec, StructureConfig config) {
        super(codec, config, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), TowerStructure::generatePieces), TowerStructure::afterPlace);
    }

    public int getSpacing() {
        return 31;
    }

    public int getOffset() {
        return this.getSpacing();
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        ChunkPos chunkPos = context.f_192705_();
        WorldgenRandom rand = context.f_192708_();
        int samples = 1;
        int y = context.f_192703_().m_156179_(chunkPos.m_151382_(8), chunkPos.m_151391_(8), Heightmap.Types.WORLD_SURFACE_WG, context.f_192707_());
        int width = 13;
        for (int x = 0; x < 1; ++x) {
            for (int z = 0; z < 1; ++z) {
                y += context.f_192703_().m_156179_(chunkPos.m_151382_(x * width), chunkPos.m_151391_(z * width), Heightmap.Types.WORLD_SURFACE_WG, context.f_192707_());
                ++samples;
            }
        }
        BlockPos pos = new BlockPos(chunkPos.f_45578_ << 4, y / samples, chunkPos.f_45579_ << 4);
        TowerPieces.assemble(context.f_192704_(), pos, Rotation.m_55956_((Random)rand), builder, (Random)rand);
    }

    private static void afterPlace(WorldGenLevel level, StructureFeatureManager structureManager, ChunkGenerator chunkGen, Random rand, BoundingBox bounds, ChunkPos chunkPos, PiecesContainer pieces) {
        GelStructure.fillBelow((WorldGenLevel)level, (Random)rand, (BoundingBox)bounds, (PiecesContainer)pieces, r -> ((double)r.nextFloat() < 0.2 ? Blocks.f_50079_ : Blocks.f_50652_).m_49966_());
    }
}

