/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.util;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.util.IEnumDragonModelTypes;
import com.github.alexthe666.iceandfire.client.model.util.IEnumDragonPoses;
import com.github.alexthe666.iceandfire.client.model.util.TabulaModelHandlerHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DragonAnimationsLibrary {
    private static final HashMap<String, TabulaModel> models = new HashMap();

    private static String toKey(IEnumDragonPoses p, IEnumDragonModelTypes m) {
        return p.getPose() + m.getModelType();
    }

    public static TabulaModel getModel(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        TabulaModel result = models.get(DragonAnimationsLibrary.toKey(pose, modelType));
        if (result == null) {
            IceAndFire.LOGGER.error("No model defined for " + pose.getPose() + modelType.getModelType() + " have you registered your animations?");
        }
        return result;
    }

    public static void registerSingle(IEnumDragonPoses pose, IEnumDragonModelTypes modelType) {
        DragonAnimationsLibrary.registerSingle(pose, modelType, "iceandfire");
    }

    public static void register(IEnumDragonPoses[] poses, IEnumDragonModelTypes[] modelTypes) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (IEnumDragonPoses p : poses) {
            futures.add(CompletableFuture.runAsync(() -> {
                for (IEnumDragonModelTypes m : modelTypes) {
                    DragonAnimationsLibrary.registerSingle(p, m, "iceandfire");
                }
            }));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
    }

    public static void register(IEnumDragonPoses[] poses, IEnumDragonModelTypes[] modelTypes, String modID) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(poses.length);
        for (IEnumDragonPoses p : poses) {
            futures.add(CompletableFuture.runAsync(() -> {
                for (IEnumDragonModelTypes m : modelTypes) {
                    DragonAnimationsLibrary.registerSingle(p, m, modID);
                }
            }));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
    }

    public static void registerSingle(IEnumDragonPoses pose, IEnumDragonModelTypes modelType, String modID) {
        TabulaModel result;
        String location = "/assets/" + modID + "/models/tabula/" + modelType.getModelType() + "dragon/" + modelType.getModelType() + "dragon_" + pose.getPose() + ".tbl";
        try {
            result = new TabulaModel(TabulaModelHandlerHelper.loadTabulaModel(location));
        }
        catch (IOException | NullPointerException e) {
            IceAndFire.LOGGER.warn("Could not load " + location + ": " + e.getMessage());
            return;
        }
        models.put(DragonAnimationsLibrary.toKey(pose, modelType), result);
    }

    public static void registerReferences(IEnumDragonPoses[] poses, IEnumDragonModelTypes modelSource, IEnumDragonModelTypes[] modelDestinations) {
        for (int i = 0; i < poses.length; ++i) {
            DragonAnimationsLibrary.registerReference(poses[i], modelSource, modelDestinations[i]);
        }
    }

    public static void registerReference(IEnumDragonPoses pose, IEnumDragonModelTypes modelSource, IEnumDragonModelTypes modelDestination) {
        TabulaModel source = DragonAnimationsLibrary.getModel(pose, modelSource);
        String destKey = DragonAnimationsLibrary.toKey(pose, modelDestination);
        if (source == null) {
            return;
        }
        if (models.containsKey(destKey)) {
            IceAndFire.LOGGER.info("Overriding existing model '" + destKey + "' with reference to '" + DragonAnimationsLibrary.toKey(pose, modelSource));
        }
        models.put(destKey, source);
    }
}

