/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.jei;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.compat.jei.firedragonforge.FireDragonForgeCategory;
import com.github.alexthe666.iceandfire.compat.jei.icedragonforge.IceDragonForgeCategory;
import com.github.alexthe666.iceandfire.compat.jei.lightningdragonforge.LightningDragonForgeCategory;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class IceAndFireJEIPlugin
implements IModPlugin {
    public static final ResourceLocation MOD = new ResourceLocation("iceandfire:iceandfire");
    public static final ResourceLocation FIRE_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:fire_dragon_forge");
    public static final ResourceLocation ICE_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:ice_dragon_forge");
    public static final ResourceLocation LIGHTNING_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:lightning_dragon_forge");

    private void addDescription(IRecipeRegistration registry, ItemStack itemStack) {
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new Component[]{new TranslatableComponent(itemStack.m_41778_() + ".jei_desc")});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        List forgeRecipeList = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(IafRecipeRegistry.DRAGON_FORGE_TYPE);
        List fire = forgeRecipeList.stream().filter(item -> item.getDragonType().equals("fire")).collect(Collectors.toList());
        List ice = forgeRecipeList.stream().filter(item -> item.getDragonType().equals("ice")).collect(Collectors.toList());
        List lightning = forgeRecipeList.stream().filter(item -> item.getDragonType().equals("lightning")).collect(Collectors.toList());
        registry.addRecipes(fire, FIRE_DRAGON_FORGE_ID);
        registry.addRecipes(ice, ICE_DRAGON_FORGE_ID);
        registry.addRecipes(lightning, LIGHTNING_DRAGON_FORGE_ID);
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.FIRE_DRAGON_BLOOD.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.ICE_DRAGON_BLOOD.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.LIGHTNING_DRAGON_BLOOD.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_RED.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BRONZE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_GRAY.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_GREEN.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BLUE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_WHITE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_SAPPHIRE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_SILVER.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_ELECTRIC.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_AMYTHEST.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_COPPER.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BLACK.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGON_SKULL_FIRE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGON_SKULL_ICE.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.DRAGON_SKULL_LIGHTNING.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.FIRE_STEW.get()));
        this.addDescription(registry, new ItemStack((ItemLike)IafItemRegistry.FROST_STEW.get()));
        for (EnumSkullType skull : EnumSkullType.values()) {
            this.addDescription(registry, new ItemStack((ItemLike)skull.skull_item.get()));
        }
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_FIRE.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_ICE.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_LIGHTNING.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_FIRE_HEAD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_ICE_HEAD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_LIGHTNING_HEAD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_AMPHITHERE.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_BIRD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_EYE.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_FAE.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_FEATHER.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_GORGON.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_HIPPOCAMPUS.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_HIPPOGRYPH_HEAD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_MERMAID.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_SEA_SERPENT.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_TROLL.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_WEEZER.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
        registry.addIngredientInfo((Object)((BannerPatternItem)IafItemRegistry.PATTERN_DREAD.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{new TranslatableComponent("item.iceandfire.custom_banner.jei_desc")});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FireDragonForgeCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new IceDragonForgeCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new LightningDragonForgeCategory()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)IafBlockRegistry.DRAGONFORGE_FIRE_CORE.get()), new ResourceLocation[]{FIRE_DRAGON_FORGE_ID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)IafBlockRegistry.DRAGONFORGE_ICE_CORE.get()), new ResourceLocation[]{ICE_DRAGON_FORGE_ID});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE.get()), new ResourceLocation[]{LIGHTNING_DRAGON_FORGE_ID});
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return MOD;
    }
}

