/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.DragonFireEvent;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceCharge;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EntityIceDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_female");
    public static final ResourceLocation MALE_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = new ResourceLocation("iceandfire", "entities/dragon/ice_dragon_skeleton");

    public EntityIceDragon(Level worldIn) {
        this((EntityType)IafEntityRegistry.ICE_DRAGON.get(), worldIn);
    }

    public EntityIceDragon(EntityType<?> t, Level worldIn) {
        super(t, worldIn, DragonType.ICE, 1.0, 1 + IafConfig.dragonAttackDamage, IafConfig.dragonHealth * 0.04, IafConfig.dragonHealth, 0.15f, 0.4f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.m_21824_()) {
            return entity.m_6095_() != this.m_6095_() && this.m_20205_() >= entity.m_20205_() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof Player || DragonUtils.isDragonTargetable(entity, IafTagRegistry.ICE_DRAGON_TARGETS) || entity instanceof WaterAnimal || !this.m_21824_() && DragonUtils.isVillager(entity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWIMMING, (Object)Boolean.FALSE);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "blue_";
            }
            case 1: {
                return "white_";
            }
            case 2: {
                return "sapphire_";
            }
            case 3: 
        }
        return "silver_";
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return (Item)IafItemRegistry.DRAGONSCALES_BLUE.get();
            }
            case 1: {
                return (Item)IafItemRegistry.DRAGONSCALES_WHITE.get();
            }
            case 2: {
                return (Item)IafItemRegistry.DRAGONSCALES_SAPPHIRE.get();
            }
            case 3: 
        }
        return (Item)IafItemRegistry.DRAGONSCALES_SILVER.get();
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return (Item)IafItemRegistry.DRAGONEGG_BLUE.get();
            }
            case 1: {
                return (Item)IafItemRegistry.DRAGONEGG_WHITE.get();
            }
            case 2: {
                return (Item)IafItemRegistry.DRAGONEGG_SAPPHIRE.get();
            }
            case 3: 
        }
        return (Item)IafItemRegistry.DRAGONEGG_SILVER.get();
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Swimming", this.m_6069_());
        compound.m_128405_("SwimmingTicks", this.ticksSwiming);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20282_(compound.m_128471_("Swimming"));
        this.ticksSwiming = compound.m_128451_("SwimmingTicks");
    }

    @Override
    public boolean m_5807_() {
        return true;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.m_21563_().m_24960_(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0), entityIn.m_20182_().m_82520_(0.0, (double)(entityIn.m_20206_() / 2.0f), 0.0)) && entityIn.m_20205_() < this.m_20205_() * 0.5f && this.m_6688_() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.m_20329_((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (!this.f_19853_.f_46443_ && this.m_20077_() && this.isAllowedToTriggerFlight() && !this.isModelDead()) {
            this.setHovering(true);
            this.m_21837_(false);
            this.m_21839_(false);
            this.flyHovering = 0;
            this.flyTicks = 0;
        }
        if (!this.f_19853_.f_46443_ && attackTarget != null) {
            if (this.m_142469_().m_82377_((double)(0.0f + this.getRenderSize() * 0.33f), (double)(0.0f + this.getRenderSize() * 0.33f), (double)(0.0f + this.getRenderSize() * 0.33f)).m_82381_(attackTarget.m_142469_())) {
                this.m_7327_((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.f_19861_)) {
                this.shootIceAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.m_20280_((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.m_20185_() - this.m_20185_();
                double difY = attackTarget.m_20186_() + (double)attackTarget.m_20206_() - this.m_20186_();
                double difZ = attackTarget.m_20189_() - this.m_20189_();
                this.m_20256_(this.m_20184_().m_82520_(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.m_142469_().m_82377_((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).m_82381_(attackTarget.m_142469_())) {
                    this.m_7327_((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        boolean swimming = this.isInMaterialWater();
        this.prevSwimProgress = this.swimProgress;
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.isInMaterialWater() && !this.m_6069_() && (!this.isFlying() && !this.isHovering() || this.flyTicks > 100)) {
            this.m_20282_(true);
            this.setHovering(false);
            this.setFlying(false);
            this.flyTicks = 0;
            this.ticksSwiming = 0;
        }
        if ((!this.isInMaterialWater() || this.isHovering() || this.isFlying()) && this.m_6069_()) {
            this.m_20282_(false);
            this.ticksSwiming = 0;
        }
        if (this.m_6069_() && !this.isModelDead()) {
            ++this.ticksSwiming;
            if (!(!this.isInMaterialWater() && !this.isOverWater() || this.ticksSwiming <= 4000 && (this.m_5448_() == null || this.m_20069_() == this.m_5448_().m_20069_()) || this.m_6162_() || this.isHovering() || this.isFlying())) {
                this.setHovering(true);
                this.m_6135_();
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.8, 0.0));
                this.m_20282_(false);
            }
        }
        if (!this.f_19853_.f_46443_ && this.isHovering() && !this.isFlying() && (this.isInMaterialWater() || this.isOverWater())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
        }
        this.swimCycle = this.swimCycle < 48 ? (this.swimCycle += 2) : 0;
        if (this.isModelDead() && this.swimCycle != 0) {
            this.swimCycle = 0;
        }
    }

    @Override
    protected boolean isIceInWater() {
        return this.isInMaterialWater();
    }

    private boolean isOverWater() {
        return this.isInMaterialWater();
    }

    public boolean isInsideWaterBlock() {
        return this.isInMaterialWater();
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.m_21187_().nextInt(5) == 0 && !this.m_6162_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                this.m_5496_(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.m_20154_().f_82479_;
                double d3 = controller.m_20154_().f_82480_;
                double d4 = controller.m_20154_().f_82481_;
                float inaccuracy = 1.0f;
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((EntityType<? extends Fireball>)((EntityType)IafEntityRegistry.ICE_DRAGON_CHARGE.get()), this.f_19853_, this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.m_6162_() ? 0.4f : (this.m_6125_() ? 1.3f : 0.8f);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                HitResult mop;
                this.m_146922_(this.f_20883_);
                if (this.f_19797_ % 5 == 0) {
                    this.m_5496_(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.m_82450_().f_82479_, mop.m_82450_().f_82480_, mop.m_82450_().f_82481_, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    public boolean isInMaterialWater() {
        return this.m_20069_();
    }

    private void shootIceAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.m_21187_().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.m_146922_(this.f_20883_);
                    Vec3 headVec = this.getHeadPosition();
                    double d2 = entity.m_20185_() - headVec.f_82479_;
                    double d3 = entity.m_20186_() - headVec.f_82480_;
                    double d4 = entity.m_20189_() - headVec.f_82481_;
                    float inaccuracy = 1.0f;
                    this.m_5496_(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((EntityType<? extends Fireball>)((EntityType)IafEntityRegistry.ICE_DRAGON_CHARGE.get()), this.f_19853_, this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = this.m_6162_() ? 0.4f : (this.m_6125_() ? 1.3f : 0.8f);
                    entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_7967_((Entity)entitylargefireball);
                    }
                    if (!entity.m_6084_() || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.m_146922_(this.f_20883_);
                    if (this.f_19797_ % 5 == 0) {
                        this.m_5496_(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1);
                    if (!entity.m_6084_() || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.m_21391_((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireEvent(this, burnX, burnY, burnZ))) {
            return;
        }
        if (syncType == 1 && !this.f_19853_.f_46443_) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.f_19853_.f_46443_) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.f_19853_.f_46443_) {
            IceAndFire.sendMSGToAll(new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.f_19853_.f_46443_) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonSyncFire(this.m_142049_(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.f_82479_;
                double d3 = burnY - headVec.f_82480_;
                double d4 = burnZ - headVec.f_82481_;
                float inaccuracy = 1.0f;
                this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge((EntityType<? extends Fireball>)((EntityType)IafEntityRegistry.ICE_DRAGON_CHARGE.get()), this.f_19853_, this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.m_6162_() ? 0.4f : (this.m_6125_() ? 1.3f : 0.8f);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7967_((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.m_21573_().m_26573_();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.f_82479_;
        double d3 = burnY - headPos.f_82480_;
        double d4 = burnZ - headPos.f_82481_;
        float particleScale = Mth.m_14036_((float)(this.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f);
        double distance = Math.max(2.5 * this.m_20275_(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.f_82479_ + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.f_82480_ + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.f_82481_ + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(particleCount) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle(EnumParticles.DragonIce, headPos.f_82479_, headPos.f_82480_, headPos.f_82481_, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.f_19853_.f_46443_) {
                BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(progressX, progressY, progressZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                BlockPos pos = new BlockPos(result.m_82450_());
                if (!this.isInMaterialWater()) {
                    IafDragonDestructionManager.destroyAreaIce(this.f_19853_, pos, this);
                }
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.f_19796_.nextFloat() * 3.0 - 1.5;
            if (!this.f_19853_.f_46443_ && !this.isInMaterialWater()) {
                IafDragonDestructionManager.destroyAreaIce(this.f_19853_, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    public boolean m_6069_() {
        if (this.f_19853_.f_46443_) {
            boolean swimming;
            this.isSwimming = swimming = ((Boolean)this.f_19804_.m_135370_(SWIMMING)).booleanValue();
            return swimming;
        }
        return this.isSwimming;
    }

    public void m_20282_(boolean swimming) {
        this.f_19804_.m_135381_(SWIMMING, (Object)swimming);
        if (!this.f_19853_.f_46443_) {
            this.isSwimming = swimming;
        }
    }

    protected SoundEvent m_7515_() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_IDLE : (this.m_6125_() ? IafSoundRegistry.ICEDRAGON_ADULT_IDLE : IafSoundRegistry.ICEDRAGON_CHILD_IDLE);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_HURT : (this.m_6125_() ? IafSoundRegistry.ICEDRAGON_ADULT_HURT : IafSoundRegistry.ICEDRAGON_CHILD_HURT);
    }

    protected SoundEvent m_5592_() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_DEATH : (this.m_6125_() ? IafSoundRegistry.ICEDRAGON_ADULT_DEATH : IafSoundRegistry.ICEDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? IafSoundRegistry.ICEDRAGON_TEEN_ROAR : (this.m_6125_() ? IafSoundRegistry.ICEDRAGON_ADULT_ROAR : IafSoundRegistry.ICEDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean m_6898_(@Nullable ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() == IafItemRegistry.FROST_STEW.get();
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.m_146922_(this.f_20883_);
                if (this.f_19797_ % 5 == 0) {
                    this.m_5496_(IafSoundRegistry.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.m_123341_() + 0.5f, (float)burningTarget.m_123342_() + 0.5f, (float)burningTarget.m_123343_() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public double getFlightSpeedModifier() {
        return super.getFlightSpeedModifier() * (double)(this.isInMaterialWater() ? 0.3f : 1.0f);
    }

    @Override
    public boolean isAllowedToTriggerFlight() {
        return super.isAllowedToTriggerFlight() && !this.m_20069_();
    }

    @Override
    protected void spawnDeathParticles() {
        if (this.f_19853_.f_46443_) {
            for (int k = 0; k < 10; ++k) {
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                IceAndFire.PROXY.spawnParticle(EnumParticles.Snowflake, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
            }
        }
    }

    @Override
    protected void spawnBabyParticles() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.m_20185_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
                float headPosZ = (float)(this.m_20189_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
                float headPosY = (float)(this.m_20186_() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                IceAndFire.PROXY.spawnParticle(EnumParticles.DragonIce, headPosX, headPosY, headPosZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getStartMetaForType() {
        return 4;
    }

    @Override
    public SoundEvent getBabyFireSound() {
        return SoundEvents.f_11771_;
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)IafItemRegistry.DRAGON_SKULL_ICE.get());
    }

    @Override
    public boolean useFlyingPathFinder() {
        return this.isFlying() || this.isInMaterialWater();
    }

    @Override
    public Item getSummoningCrystal() {
        return (Item)IafItemRegistry.SUMMONING_CRYSTAL_ICE.get();
    }

    @Override
    protected Item getBloodItem() {
        return (Item)IafItemRegistry.ICE_DRAGON_BLOOD.get();
    }

    @Override
    protected ItemLike getHeartItem() {
        return (ItemLike)IafItemRegistry.ICE_DRAGON_HEART.get();
    }
}

