/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentBubbles;
import com.github.alexthe666.iceandfire.entity.EntitySlowPart;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.FlyingAITarget;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIGetInWater;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIJump;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIMeleeJump;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentAIRandomSwimming;
import com.github.alexthe666.iceandfire.entity.ai.SeaSerpentPathNavigator;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntitySeaSerpent
extends Animal
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)15);
    public static final Animation ANIMATION_ROAR = Animation.create((int)40);
    public static final int TIME_BETWEEN_ROARS = 300;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntitySeaSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(EntitySeaSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.m_135353_(EntitySeaSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BREATHING = SynchedEntityData.m_135353_(EntitySeaSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANCIENT = SynchedEntityData.m_135353_(EntitySeaSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final com.google.common.base.Predicate<Entity> NOT_SEA_SERPENT = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((LivingEntity)entity);
        }
    };
    private static final com.google.common.base.Predicate<Entity> NOT_SEA_SERPENT_IN_WATER = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof LivingEntity && !(entity instanceof EntitySeaSerpent) && DragonUtils.isAlive((LivingEntity)entity) && entity.m_20072_();
        }
    };
    public int swimCycle;
    public float jumpProgress = 0.0f;
    public float wantJumpProgress = 0.0f;
    public float jumpRot = 0.0f;
    public float prevJumpRot = 0.0f;
    public float breathProgress = 0.0f;
    public boolean attackDecision = false;
    private int animationTick;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[9];
    private float lastScale;
    private boolean isLandNavigator;
    private boolean changedSwimBehavior = false;
    public int jumpCooldown = 0;
    private int ticksSinceRoar = 0;
    private boolean isBreathing;
    private final float[] tailYaw = new float[5];
    private final float[] prevTailYaw = new float[5];
    private final float[] tailPitch = new float[5];
    private final float[] prevTailPitch = new float[5];

    public EntitySeaSerpent(EntityType<EntitySeaSerpent> t, Level worldIn) {
        super(t, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
        this.switchNavigator(false);
        this.f_19811_ = true;
        this.resetParts(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    private static BlockPos clampBlockPosToWater(Entity entity, Level world, BlockPos pos) {
        BlockPos topY = new BlockPos((double)pos.m_123341_(), entity.m_20186_(), (double)pos.m_123343_());
        BlockPos bottomY = new BlockPos((double)pos.m_123341_(), entity.m_20186_(), (double)pos.m_123343_());
        while (EntitySeaSerpent.isWaterBlock(world, topY) && topY.m_123342_() < world.m_151558_()) {
            topY = topY.m_7494_();
        }
        while (EntitySeaSerpent.isWaterBlock(world, bottomY) && bottomY.m_123342_() > 0) {
            bottomY = bottomY.m_7495_();
        }
        return new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)(bottomY.m_123342_() + 1), (int)(topY.m_123342_() - 1)), pos.m_123343_());
    }

    public static boolean isWaterBlock(Level world, BlockPos pos) {
        return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SeaSerpentAIGetInWater(this));
        this.f_21345_.m_25352_(1, (Goal)new SeaSerpentAIMeleeJump(this));
        this.f_21345_.m_25352_(1, (Goal)new SeaSerpentAIAttackMelee(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new SeaSerpentAIRandomSwimming((PathfinderMob)this, 1.0, 2));
        this.f_21345_.m_25352_(3, (Goal)new SeaSerpentAIJump(this, 4));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityMutlipartPart.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, new FlyingAITarget<LivingEntity>((Mob)this, LivingEntity.class, 150, false, false, (Predicate<LivingEntity>)NOT_SEA_SERPENT_IN_WATER));
        this.f_21346_.m_25352_(3, new FlyingAITarget<Player>((Mob)this, Player.class, 0, false, false, (Predicate<LivingEntity>)NOT_SEA_SERPENT));
    }

    protected int m_6552_(@NotNull Player player) {
        return this.isAncient() ? 30 : 15;
    }

    public void m_6138_() {
        List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82363_((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityMutlipartPart) && entity.m_6094_()).forEach(entity -> entity.m_7334_((Entity)this));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.f_21344_.m_7008_(true);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new SwimmingMoveHelper(this);
            this.f_21344_ = new SeaSerpentPathNavigator((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    public boolean isDirectPathBetweenPoints(BlockPos pos) {
        Vec3 bector3d1;
        Vec3 vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(vector3d, bector3d1 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, IafConfig.seaSerpentBaseHealth).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, (double)Math.min(2048, IafConfig.dragonTargetSearchLength)).m_22268_(Attributes.f_22284_, 3.0);
    }

    @Override
    public AttributeSupplier.Builder getConfigurableAttributes() {
        return EntitySeaSerpent.bakeAttributes();
    }

    public void resetParts(float scale) {
        this.clearParts();
        this.segments = new EntityMutlipartPart[9];
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 3) {
                parentToSet = i <= 4 ? this : this.segments[i - 1];
                this.segments[i] = new EntitySlowPart((Entity)parentToSet, 0.5f * scale, 180.0f, 0.0f, 0.5f * scale, 0.5f * scale, 1.0f);
            } else {
                parentToSet = i == 0 ? this : this.segments[i - 1];
                this.segments[i] = new EntitySlowPart((Entity)parentToSet, -0.4f * scale, 180.0f, 0.0f, 0.45f * scale, 0.4f * scale, 1.0f);
            }
            this.segments[i].m_20359_((Entity)this);
        }
    }

    public void onUpdateParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null || entity.shouldContinuePersisting()) continue;
            this.f_19853_.m_7967_((Entity)entity);
        }
    }

    private void clearParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.clearParts();
        super.m_142687_(reason);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose poseIn) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public float m_6134_() {
        return this.getSeaSerpentScale();
    }

    public void m_6210_() {
        super.m_6210_();
        float scale = this.getSeaSerpentScale();
        if (scale != this.lastScale) {
            this.resetParts(this.getSeaSerpentScale());
        }
        this.lastScale = scale;
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            return true;
        }
        return false;
    }

    public void m_8119_() {
        int i;
        super.m_8119_();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.m_6210_();
        this.onUpdateParts();
        if (this.m_20069_()) {
            this.spawnParticlesAroundEntity((ParticleOptions)ParticleTypes.f_123795_, (Entity)this, (int)this.getSeaSerpentScale());
        }
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        for (i = 0; i < this.tailYaw.length; ++i) {
            this.prevTailYaw[i] = this.tailYaw[i];
        }
        for (i = 0; i < this.tailPitch.length; ++i) {
            this.prevTailPitch[i] = this.tailPitch[i];
        }
        this.tailYaw[0] = this.f_20883_;
        this.tailPitch[0] = this.m_146909_();
        for (i = 1; i < this.tailYaw.length; ++i) {
            this.tailYaw[i] = this.prevTailYaw[i - 1];
        }
        for (i = 1; i < this.tailPitch.length; ++i) {
            this.tailPitch[i] = this.prevTailPitch[i - 1];
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public float getPieceYaw(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailYaw[index] + (this.tailYaw[index] - this.prevTailYaw[index]) * partialTicks;
        }
        return 0.0f;
    }

    public float getPiecePitch(int index, float partialTicks) {
        if (index < this.segments.length && index >= 0) {
            return this.prevTailPitch[index] + (this.tailPitch[index] - this.prevTailPitch[index]) * partialTicks;
        }
        return 0.0f;
    }

    private void spawnParticlesAroundEntity(ParticleOptions type, Entity entity, int count) {
        for (int i = 0; i < count; ++i) {
            double z;
            double y;
            double x = entity.m_20185_() + (double)(this.f_19796_.nextFloat() * entity.m_20205_() * 2.0f) - (double)entity.m_20205_();
            if (this.f_19853_.m_8055_(new BlockPos(x, y = entity.m_20186_() + 0.5 + (double)(this.f_19796_.nextFloat() * entity.m_20206_()), z = entity.m_20189_() + (double)(this.f_19796_.nextFloat() * entity.m_20205_() * 2.0f) - (double)entity.m_20205_())).m_60767_() != Material.f_76305_) continue;
            this.f_19853_.m_7106_(type, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void spawnSlamParticles(ParticleOptions type) {
        int i = 0;
        while ((float)i < this.getSeaSerpentScale() * 3.0f) {
            for (int i1 = 0; i1 < 5; ++i1) {
                double motionX = this.m_21187_().nextGaussian() * 0.07;
                double motionY = this.m_21187_().nextGaussian() * 0.07;
                double motionZ = this.m_21187_().nextGaussian() * 0.07;
                float radius = 1.25f * this.getSeaSerpentScale();
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1 * 1.0f;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                if (!this.f_19853_.f_46443_) continue;
                this.f_19853_.m_6493_(type, true, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(JUMPING, (Object)false);
        this.f_19804_.m_135372_(BREATHING, (Object)false);
        this.f_19804_.m_135372_(ANCIENT, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("TicksSinceRoar", this.ticksSinceRoar);
        compound.m_128405_("JumpCooldown", this.jumpCooldown);
        compound.m_128350_("Scale", this.getSeaSerpentScale());
        compound.m_128379_("JumpingOutOfWater", this.isJumpingOutOfWater());
        compound.m_128379_("AttackDecision", this.attackDecision);
        compound.m_128379_("Breathing", this.isBreathing());
        compound.m_128379_("Ancient", this.isAncient());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.ticksSinceRoar = compound.m_128451_("TicksSinceRoar");
        this.jumpCooldown = compound.m_128451_("JumpCooldown");
        this.setSeaSerpentScale(compound.m_128457_("Scale"));
        this.setJumpingOutOfWater(compound.m_128471_("JumpingOutOfWater"));
        this.attackDecision = compound.m_128471_("AttackDecision");
        this.setBreathing(compound.m_128471_("Breathing"));
        this.setAncient(compound.m_128471_("Ancient"));
    }

    private void updateAttributes() {
        this.m_21051_(Attributes.f_22279_).m_22100_(Math.min(0.25, 0.15 * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.m_21051_(Attributes.f_22281_).m_22100_(Math.max(4.0, IafConfig.seaSerpentAttackStrength * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.m_21051_(Attributes.f_22276_).m_22100_(Math.max(10.0, IafConfig.seaSerpentBaseHealth * (double)this.getSeaSerpentScale() * (double)this.getAncientModifier()));
        this.m_21051_(Attributes.f_22277_).m_22100_((double)Math.min(2048, IafConfig.dragonTargetSearchLength));
        this.m_5634_(30.0f * this.getSeaSerpentScale());
    }

    private float getAncientModifier() {
        return this.isAncient() ? 1.5f : 1.0f;
    }

    public float getSeaSerpentScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    private void setSeaSerpentScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean isJumpingOutOfWater() {
        return (Boolean)this.f_19804_.m_135370_(JUMPING);
    }

    public void setJumpingOutOfWater(boolean jump) {
        this.f_19804_.m_135381_(JUMPING, (Object)jump);
    }

    public boolean isAncient() {
        return (Boolean)this.f_19804_.m_135370_(ANCIENT);
    }

    public void setAncient(boolean ancient) {
        this.f_19804_.m_135381_(ANCIENT, (Object)ancient);
    }

    public boolean isBreathing() {
        if (this.f_19853_.f_46443_) {
            boolean breathing;
            this.isBreathing = breathing = ((Boolean)this.f_19804_.m_135370_(BREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathing;
    }

    public void setBreathing(boolean breathing) {
        this.f_19804_.m_135381_(BREATHING, (Object)breathing);
        if (!this.f_19853_.f_46443_) {
            this.isBreathing = breathing;
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        boolean breathing = this.isBreathing() && this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_ROAR;
        boolean jumping = !this.m_20069_() && !this.m_20096_() && this.m_20184_().f_82480_ >= 0.0;
        boolean wantJumping = false;
        boolean ground = !this.m_20069_() && this.f_19861_;
        boolean prevJumping = this.isJumpingOutOfWater();
        ++this.ticksSinceRoar;
        ++this.jumpCooldown;
        this.prevJumpRot = this.jumpRot;
        if (this.ticksSinceRoar > 300 && this.isAtSurface() && this.getAnimation() != ANIMATION_BITE && this.jumpProgress == 0.0f && !this.isJumpingOutOfWater()) {
            this.setAnimation(ANIMATION_ROAR);
            this.ticksSinceRoar = 0;
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 1) {
            this.m_5496_(IafSoundRegistry.SEA_SERPENT_ROAR, this.m_6121_() + 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            this.m_5496_(IafSoundRegistry.SEA_SERPENT_BITE, this.m_6121_(), 1.0f);
        }
        if (this.isJumpingOutOfWater() && EntitySeaSerpent.isWaterBlock(this.f_19853_, this.m_142538_().m_6630_(2))) {
            this.setJumpingOutOfWater(false);
        }
        this.swimCycle = this.swimCycle < 38 ? (this.swimCycle += 2) : 0;
        if (breathing && this.breathProgress < 20.0f) {
            this.breathProgress += 0.5f;
        } else if (!breathing && this.breathProgress > 0.0f) {
            this.breathProgress -= 0.5f;
        }
        if (jumping && this.jumpProgress < 10.0f) {
            this.jumpProgress += 0.5f;
        } else if (!jumping && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 0.5f;
        }
        if (wantJumping && this.wantJumpProgress < 10.0f) {
            this.wantJumpProgress += 2.0f;
        } else if (!wantJumping && this.wantJumpProgress > 0.0f) {
            this.wantJumpProgress -= 2.0f;
        }
        if (this.isJumpingOutOfWater() && this.jumpRot < 1.0f) {
            this.jumpRot += 0.1f;
        } else if (!this.isJumpingOutOfWater() && this.jumpRot > 0.0f) {
            this.jumpRot -= 0.1f;
        }
        if (prevJumping && !this.isJumpingOutOfWater()) {
            this.m_5496_(IafSoundRegistry.SEA_SERPENT_SPLASH, 5.0f, 0.75f);
            this.spawnSlamParticles((ParticleOptions)ParticleTypes.f_123795_);
            this.doSplashDamage();
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.m_146926_(Mth.m_14036_((float)((float)this.m_20184_().f_82480_ * 20.0f), (float)-90.0f, (float)90.0f));
        if (this.changedSwimBehavior) {
            this.changedSwimBehavior = false;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.attackDecision) {
                this.setBreathing(false);
            }
            if (this.m_5448_() != null && this.getAnimation() != ANIMATION_ROAR) {
                if (!this.attackDecision) {
                    if (!this.m_5448_().m_20069_() || !this.m_142582_((Entity)this.m_5448_()) || this.m_20270_((Entity)this.m_5448_()) < 30.0f * this.getSeaSerpentScale()) {
                        this.attackDecision = true;
                    }
                    if (!this.attackDecision) {
                        this.shoot(this.m_5448_());
                    }
                } else if (this.m_20280_((Entity)this.m_5448_()) > (double)(200.0f * this.getSeaSerpentScale())) {
                    this.attackDecision = false;
                }
            } else {
                this.setBreathing(false);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.m_5448_() != null && (this.isTouchingMob((Entity)this.m_5448_()) || this.m_20280_((Entity)this.m_5448_()) < 50.0)) {
            this.hurtMob(this.m_5448_());
        }
        this.breakBlock();
        if (!this.f_19853_.f_46443_ && this.m_20159_() && this.m_20201_() instanceof Boat) {
            Boat boat = (Boat)this.m_20201_();
            boat.m_142687_(Entity.RemovalReason.KILLED);
            this.m_8127_();
        }
    }

    private boolean isAtSurface() {
        BlockPos pos = this.m_142538_();
        return EntitySeaSerpent.isWaterBlock(this.f_19853_, pos.m_7495_()) && !EntitySeaSerpent.isWaterBlock(this.f_19853_, pos.m_7494_());
    }

    private void doSplashDamage() {
        double getWidth = 2.0 * (double)this.getSeaSerpentScale();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(getWidth, getWidth * 0.5, getWidth), NOT_SEA_SERPENT);
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity) || !DragonUtils.isAlive((LivingEntity)entity)) continue;
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            this.destroyBoat(entity);
            double xRatio = this.m_20185_() - entity.m_20185_();
            double zRatio = this.m_20189_() - entity.m_20189_();
            float f = Mth.m_14116_((float)((float)(xRatio * xRatio + zRatio * zRatio)));
            float strength = 0.3f * this.getSeaSerpentScale();
            entity.m_20256_(entity.m_20184_().m_82542_(0.5, 1.0, 0.5));
            entity.m_20256_(entity.m_20184_().m_82520_(xRatio / (double)f * (double)strength, (double)strength, zRatio / (double)f * (double)strength));
        }
    }

    public void destroyBoat(Entity sailor) {
        if (sailor.m_20202_() != null && sailor.m_20202_() instanceof Boat && !this.f_19853_.f_46443_) {
            Boat boat = (Boat)sailor.m_20202_();
            boat.m_142687_(Entity.RemovalReason.KILLED);
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                for (int i = 0; i < 3; ++i) {
                    boat.m_5552_(new ItemStack((ItemLike)boat.m_38387_().m_38434_().m_5456_()), 0.0f);
                }
                for (int j = 0; j < 2; ++j) {
                    boat.m_19983_(new ItemStack((ItemLike)Items.f_42398_));
                }
            }
        }
    }

    private boolean isPreyAtSurface() {
        if (this.m_5448_() != null) {
            BlockPos pos = this.m_5448_().m_142538_();
            return !EntitySeaSerpent.isWaterBlock(this.f_19853_, pos.m_6630_((int)Math.ceil(this.m_5448_().m_20206_())));
        }
        return false;
    }

    private void hurtMob(LivingEntity entity) {
        if (this.getAnimation() == ANIMATION_BITE && entity != null && this.getAnimationTick() == 6) {
            this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            this.attackDecision = this.m_21187_().nextBoolean();
        }
    }

    public void moveJumping() {
        float velocity = 0.5f;
        double x = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        double z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        float f = Mth.m_14116_((float)((float)(x * x + z * z)));
        x /= (double)f;
        z /= (double)f;
        this.m_20334_(x *= (double)velocity, this.m_20184_().f_82480_, z *= (double)velocity);
    }

    public boolean isTouchingMob(Entity entity) {
        if (this.m_142469_().m_82363_(1.0, 1.0, 1.0).m_82381_(entity.m_142469_())) {
            return true;
        }
        for (EntityMutlipartPart segment : this.segments) {
            if (!segment.m_142469_().m_82363_(1.0, 1.0, 1.0).m_82381_(entity.m_142469_())) continue;
            return true;
        }
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public void breakBlock() {
        if (IafConfig.seaSerpentGriefing) {
            for (int a = (int)Math.round(this.m_142469_().f_82288_) - 2; a <= (int)Math.round(this.m_142469_().f_82291_) + 2; ++a) {
                for (int b = (int)Math.round(this.m_142469_().f_82289_) - 1; b <= (int)Math.round(this.m_142469_().f_82292_) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.m_142469_().f_82290_) - 2; c <= (int)Math.round(this.m_142469_().f_82293_) + 2; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.f_19853_.m_8055_(pos);
                        FluidState fluidState = this.f_19853_.m_6425_(pos);
                        Block block = state.m_60734_();
                        if (state.m_60795_() || state.m_60808_((BlockGetter)this.f_19853_, pos).m_83281_() || state.m_60767_() != Material.f_76300_ && state.m_60767_() != Material.f_76274_ || !fluidState.m_76178_() || block == Blocks.f_50016_ || this.f_19853_.f_46443_) continue;
                        this.f_19853_.m_46961_(pos, true);
                    }
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        boolean ancient;
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_21187_().nextInt(7));
        boolean bl = ancient = this.m_21187_().nextInt(16) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + this.m_21187_().nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + this.m_21187_().nextFloat() * 4.0f);
        }
        this.updateAttributes();
        return spawnDataIn;
    }

    public void onWorldSpawn(Random random) {
        boolean ancient;
        this.setVariant(random.nextInt(7));
        boolean bl = ancient = random.nextInt(15) == 1;
        if (ancient) {
            this.setAncient(true);
            this.setSeaSerpentScale(6.0f + random.nextFloat() * 3.0f);
        } else {
            this.setSeaSerpentScale(1.5f + random.nextFloat() * 4.0f);
        }
        this.updateAttributes();
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverWorld, @NotNull AgeableMob ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_ROAR, ANIMATION_SPEAK};
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return IafSoundRegistry.SEA_SERPENT_IDLE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return IafSoundRegistry.SEA_SERPENT_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return IafSoundRegistry.SEA_SERPENT_DIE;
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_8032_();
    }

    protected void m_6677_(@NotNull DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 43;
    }

    private void shoot(LivingEntity entity) {
        if (!this.attackDecision) {
            if (!this.m_20069_()) {
                this.setBreathing(false);
                this.attackDecision = true;
            }
            if (this.isBreathing()) {
                if (this.f_19797_ % 40 == 0) {
                    this.m_5496_(IafSoundRegistry.SEA_SERPENT_BREATH, 4.0f, 1.0f);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.m_146922_(this.f_20883_);
                    float f1 = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float headPosX = f1 + (float)(this.segments[0].m_20185_() + (double)(1.3f * this.getSeaSerpentScale() * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
                    float headPosZ = f2 + (float)(this.segments[0].m_20189_() + (double)(1.3f * this.getSeaSerpentScale() * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
                    float headPosY = f3 + (float)(this.segments[0].m_20186_() + (double)(0.2f * this.getSeaSerpentScale()));
                    double d2 = entity.m_20185_() - (double)headPosX;
                    double d3 = entity.m_20186_() - (double)headPosY;
                    double d4 = entity.m_20189_() - (double)headPosZ;
                    float inaccuracy = 1.0f;
                    EntitySeaSerpentBubbles entitylargefireball = new EntitySeaSerpentBubbles((EntityType<? extends Fireball>)((EntityType)IafEntityRegistry.SEA_SERPENT_BUBBLES.get()), this.f_19853_, this, d2 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.m_6034_(headPosX, headPosY, headPosZ);
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_7967_((Entity)entitylargefireball);
                    }
                    if (!entity.m_6084_() || entity == null) {
                        this.setBreathing(false);
                        this.attackDecision = this.m_21187_().nextBoolean();
                    }
                }
            } else {
                this.setBreathing(true);
            }
        }
        this.m_21391_((Entity)entity, 360.0f, 360.0f);
    }

    public EnumSeaSerpent getEnum() {
        switch (this.getVariant()) {
            default: {
                return EnumSeaSerpent.BLUE;
            }
            case 1: {
                return EnumSeaSerpent.BRONZE;
            }
            case 2: {
                return EnumSeaSerpent.DEEPBLUE;
            }
            case 3: {
                return EnumSeaSerpent.GREEN;
            }
            case 4: {
                return EnumSeaSerpent.PURPLE;
            }
            case 5: {
                return EnumSeaSerpent.RED;
            }
            case 6: 
        }
        return EnumSeaSerpent.TEAL;
    }

    public void m_7023_(@NotNull Vec3 vec) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec);
        }
    }

    public void m_5837_(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        this.attackDecision = this.m_21187_().nextBoolean();
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public int m_6056_() {
        return 1000;
    }

    public void onJumpHit(LivingEntity target) {
    }

    public boolean shouldUseJumpAttack(LivingEntity attackTarget) {
        return !attackTarget.m_20069_() || this.isPreyAtSurface();
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source == DamageSource.f_19315_ || source == DamageSource.f_19312_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || source == DamageSource.f_19308_ || source.m_19384_() || super.m_6673_(source);
    }

    public class SwimmingMoveHelper
    extends MoveControl {
        private final EntitySeaSerpent dolphin;

        public SwimmingMoveHelper(EntitySeaSerpent dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void m_8126_() {
            if (this.dolphin.m_20069_()) {
                this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.dolphin.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.dolphin.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.dolphin.m_20186_()) * d1 + (d2 = this.f_24977_ - this.dolphin.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.m_146922_(this.m_24991_(this.dolphin.m_146908_(), f, 10.0f));
                    this.dolphin.f_20883_ = this.dolphin.m_146908_();
                    this.dolphin.f_20885_ = this.dolphin.m_146908_();
                    float f1 = (float)(this.f_24978_ * 3.0);
                    if (this.dolphin.m_20069_()) {
                        this.dolphin.m_7910_(f1 * 0.02f);
                        float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, (double)this.dolphin.m_6113_() * d1 * 0.6, 0.0));
                        this.dolphin.m_146926_(this.m_24991_(this.dolphin.m_146909_(), f2, 1.0f));
                        float f3 = Mth.m_14089_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        this.dolphin.f_20902_ = f3 * f1;
                        this.dolphin.f_20901_ = -f4 * f1;
                    } else {
                        this.dolphin.m_7910_(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.m_7910_(0.0f);
                this.dolphin.m_21570_(0.0f);
                this.dolphin.m_21567_(0.0f);
                this.dolphin.m_21564_(0.0f);
            }
        }
    }
}

