/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class MyrmexAIAttackMelee
extends Goal {
    protected EntityMyrmexBase myrmex;
    private int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;
    private PathResult attackPath;

    public MyrmexAIAttackMelee(EntityMyrmexBase dragon, double speedIn, boolean useLongMemory) {
        this.myrmex = dragon;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity LivingEntity2 = this.myrmex.m_5448_();
        if (!(this.myrmex.m_21573_() instanceof AdvancedPathNavigate)) {
            return false;
        }
        if (LivingEntity2 instanceof Player && this.myrmex.getHive() != null && !this.myrmex.getHive().isPlayerReputationLowEnoughToFight(LivingEntity2.m_142081_())) {
            return false;
        }
        if (LivingEntity2 == null) {
            return false;
        }
        if (!LivingEntity2.m_6084_()) {
            return false;
        }
        if (!this.myrmex.canMove()) {
            return false;
        }
        this.attackPath = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToLivingEntity((Entity)LivingEntity2, this.speedTowardsTarget);
        if (this.attackPath != null) {
            return true;
        }
        return this.getAttackReachSqr(LivingEntity2) >= this.myrmex.m_20275_(LivingEntity2.m_20185_(), LivingEntity2.m_142469_().f_82289_, LivingEntity2.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity LivingEntity2 = this.myrmex.m_5448_();
        if (this.myrmex.m_21214_() != null && this.myrmex.m_21214_().m_6084_()) {
            LivingEntity2 = this.myrmex.m_21214_();
        }
        if (LivingEntity2 != null && !LivingEntity2.m_6084_() || !(this.myrmex.m_21573_() instanceof AdvancedPathNavigate)) {
            this.m_8041_();
            return false;
        }
        return LivingEntity2 != null && LivingEntity2.m_6084_() && (!(LivingEntity2 instanceof Player) || !LivingEntity2.m_5833_() && !((Player)LivingEntity2).m_7500_());
    }

    public void m_8056_() {
        this.delayCounter = 0;
    }

    public void m_8041_() {
        LivingEntity LivingEntity2 = this.myrmex.m_5448_();
        if (LivingEntity2 instanceof Player && (LivingEntity2.m_5833_() || ((Player)LivingEntity2).m_7500_())) {
            this.myrmex.m_6710_(null);
            this.myrmex.m_21335_(null);
        }
    }

    public void m_8037_() {
        LivingEntity entity = this.myrmex.m_5448_();
        if (entity != null) {
            this.myrmex.m_21573_().m_5624_((Entity)entity, this.speedTowardsTarget);
            double d0 = this.myrmex.m_20275_(entity.m_20185_(), entity.m_142469_().f_82289_, entity.m_20189_());
            double d1 = this.getAttackReachSqr(entity);
            --this.delayCounter;
            if ((this.longMemory || this.myrmex.m_21574_().m_148306_((Entity)entity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.myrmex.m_21187_().nextFloat() < 0.05f)) {
                this.targetX = entity.m_20185_();
                this.targetY = entity.m_142469_().f_82289_;
                this.targetZ = entity.m_20189_();
                this.delayCounter = 4 + this.myrmex.m_21187_().nextInt(7);
                Objects.requireNonNull(this);
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (this.myrmex.canMove()) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick <= 0) {
                this.attackTick = 20;
                this.myrmex.m_6674_(InteractionHand.MAIN_HAND);
                this.myrmex.m_7327_((Entity)entity);
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.myrmex.m_20205_() * 2.0f * this.myrmex.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

