/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class SeaSerpentAIAttackMelee
extends Goal {
    protected final int attackInterval = 20;
    protected EntitySeaSerpent attacker;
    protected int attackTick;
    Level world;
    double speedTowardsTarget;
    boolean longMemory;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;

    public SeaSerpentAIAttackMelee(EntitySeaSerpent amphithere, double speedIn, boolean useLongMemory) {
        this.attacker = amphithere;
        this.world = amphithere.f_19853_;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity LivingEntity2 = this.attacker.m_5448_();
        if (LivingEntity2 == null || this.attacker.shouldUseJumpAttack(LivingEntity2) && this.attacker.jumpCooldown <= 0) {
            return false;
        }
        if (!LivingEntity2.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)LivingEntity2, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(LivingEntity2) >= this.attacker.m_20275_(LivingEntity2.m_20185_(), LivingEntity2.m_142469_().f_82289_, LivingEntity2.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity LivingEntity2 = this.attacker.m_5448_();
        if (LivingEntity2 == null) {
            return false;
        }
        if (!LivingEntity2.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(LivingEntity2.m_142538_())) {
            return false;
        }
        return !(LivingEntity2 instanceof Player) || !LivingEntity2.m_5833_() && !((Player)LivingEntity2).m_7500_();
    }

    public void m_8056_() {
        if (this.attacker.m_20069_()) {
            this.attacker.m_21566_().m_6849_(this.targetX, this.targetY, this.targetZ, (double)0.1f);
        } else {
            this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        }
        this.delayCounter = 0;
    }

    public void m_8041_() {
        LivingEntity LivingEntity2 = this.attacker.m_5448_();
        if (LivingEntity2 instanceof Player && (LivingEntity2.m_5833_() || ((Player)LivingEntity2).m_7500_())) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity LivingEntity2 = this.attacker.m_5448_();
        if (LivingEntity2 != null) {
            if (this.attacker.m_20069_()) {
                this.attacker.m_21566_().m_6849_(LivingEntity2.m_20185_(), LivingEntity2.m_20186_() + (double)LivingEntity2.m_20192_(), LivingEntity2.m_20189_(), 0.1);
            }
            this.attacker.m_21563_().m_24960_((Entity)LivingEntity2, 30.0f, 30.0f);
            --this.delayCounter;
            if ((this.longMemory || this.attacker.m_21574_().m_148306_((Entity)LivingEntity2)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || LivingEntity2.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_21187_().nextFloat() < 0.05f)) {
                double d0 = this.attacker.m_20275_(LivingEntity2.m_20185_(), LivingEntity2.m_142469_().f_82289_, LivingEntity2.m_20189_());
                this.targetX = LivingEntity2.m_20185_();
                this.targetY = LivingEntity2.m_142469_().f_82289_;
                this.targetZ = LivingEntity2.m_20189_();
                this.delayCounter = 4 + this.attacker.m_21187_().nextInt(7);
                Objects.requireNonNull(this);
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.m_21573_().m_5624_((Entity)LivingEntity2, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(LivingEntity2);
        }
    }

    protected void checkAndPerformAttack(LivingEntity enemy) {
        if (this.attacker.isTouchingMob((Entity)enemy)) {
            this.attackTick = 20;
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.attacker.m_7327_((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

