/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;

public class StymphalianBirdAIAirTarget
extends Goal {
    private final EntityStymphalianBird bird;

    public StymphalianBirdAIAirTarget(EntityStymphalianBird bird) {
        this.bird = bird;
    }

    public static BlockPos getNearbyAirTarget(EntityStymphalianBird bird) {
        if (bird.m_5448_() == null) {
            BlockPos pos = DragonUtils.getBlockInViewStymphalian(bird);
            if (pos != null && bird.f_19853_.m_8055_(pos).m_60767_() == Material.f_76296_) {
                return pos;
            }
            if (bird.flock != null && bird.flock.isLeader(bird)) {
                bird.flock.setTarget(bird.airTarget);
            }
        } else {
            return new BlockPos((double)((int)bird.m_5448_().m_20185_()), (double)((float)((int)bird.m_5448_().m_20186_()) + bird.m_5448_().m_20192_()), (double)((int)bird.m_5448_().m_20189_()));
        }
        return bird.m_142538_();
    }

    public boolean m_8036_() {
        if (this.bird != null) {
            if (!this.bird.isFlying()) {
                return false;
            }
            if (this.bird.m_6162_() || this.bird.doesWantToLand()) {
                return false;
            }
            if (this.bird.airTarget != null && this.bird.isTargetBlocked(Vec3.m_82512_((Vec3i)this.bird.airTarget))) {
                this.bird.airTarget = null;
            }
            if (this.bird.airTarget != null) {
                return false;
            }
            Vec3 vec = this.findAirTarget();
            if (vec == null) {
                return false;
            }
            this.bird.airTarget = new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.bird.isFlying()) {
            return false;
        }
        if (this.bird.m_6162_()) {
            return false;
        }
        return this.bird.airTarget != null;
    }

    public Vec3 findAirTarget() {
        return Vec3.m_82512_((Vec3i)StymphalianBirdAIAirTarget.getNearbyAirTarget(this.bird));
    }
}

