/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ItemLike;

public class ChickenProperties {
    private static final String CHICKEN_DATA = "TimeUntilNextEggIaf";
    private static final Random rand = new Random();

    private static int createDefaultTime() {
        return rand.nextInt(6000) + 6000;
    }

    private static CompoundTag createDefaultData(CompoundTag nbt) {
        nbt.m_128405_(CHICKEN_DATA, ChickenProperties.createDefaultTime());
        return nbt;
    }

    public static int getTimeRemaining(LivingEntity entity) {
        CompoundTag nbt = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (!nbt.m_128441_(CHICKEN_DATA)) {
            ChickenProperties.createDefaultData(nbt);
            CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
        }
        return nbt.m_128451_(CHICKEN_DATA);
    }

    public static void setTimeRemaining(LivingEntity entity, int time) {
        CompoundTag nbt = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        nbt.m_128405_(CHICKEN_DATA, time);
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
    }

    public static void tickChicken(LivingEntity entity) {
        int timeUntilNextEgg = ChickenProperties.getTimeRemaining(entity);
        if (timeUntilNextEgg <= 0) {
            if (entity.m_21187_().nextInt(IafConfig.cockatriceEggChance + 1) == 0 && entity.f_19797_ > 30) {
                entity.m_5496_(SoundEvents.f_11753_, 2.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                entity.m_5496_(SoundEvents.f_11752_, 1.0f, (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                entity.m_20000_((ItemLike)IafItemRegistry.ROTTEN_EGG.get(), 1);
            }
            ChickenProperties.setTimeRemaining(entity, ChickenProperties.createDefaultTime());
        } else {
            ChickenProperties.setTimeRemaining(entity, timeUntilNextEgg - 1);
        }
    }
}

