/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;

public class FrozenProperties {
    private static final String FROZEN_DATA = "FrozenDataIaf";
    private static final String FROZEN_BOOL = "IsFrozen";
    private static final String FROZEN_TIME = "TicksUntilUnfrozen";
    private static final Random rand = new Random();

    private static CompoundTag getOrCreateFrozenData(LivingEntity entity) {
        return FrozenProperties.getOrCreateFrozenData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundTag getOrCreateFrozenData(CompoundTag entityData) {
        if (entityData.m_128425_(FROZEN_DATA, 10)) {
            return (CompoundTag)entityData.m_128423_(FROZEN_DATA);
        }
        return FrozenProperties.createDefaultData();
    }

    private static CompoundTag createDefaultData() {
        CompoundTag nbt = new CompoundTag();
        return FrozenProperties.clearFrozenStatus(nbt);
    }

    private static CompoundTag clearFrozenStatus(CompoundTag nbt, LivingEntity entity, boolean breakIce) {
        if (breakIce) {
            for (int i = 0; i < 15; ++i) {
                entity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)IafBlockRegistry.DRAGON_ICE.get()).m_49966_()), entity.m_20185_() + (rand.nextDouble() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + rand.nextDouble() * (double)entity.m_20206_(), entity.m_20189_() + (rand.nextDouble() - 0.5) * (double)entity.m_20205_(), 0.0, 0.0, 0.0);
            }
            entity.m_5496_(SoundEvents.f_11983_, 3.0f, 1.0f);
        }
        return FrozenProperties.clearFrozenStatus(nbt);
    }

    private static CompoundTag clearFrozenStatus(CompoundTag nbt) {
        nbt.m_128405_(FROZEN_TIME, 0);
        nbt.m_128379_(FROZEN_BOOL, false);
        return nbt;
    }

    public static boolean isFrozen(LivingEntity entity) {
        CompoundTag nbt;
        if (!(entity instanceof EntityIceDragon) && (nbt = FrozenProperties.getOrCreateFrozenData(entity)).m_128441_(FROZEN_BOOL)) {
            return nbt.m_128471_(FROZEN_BOOL);
        }
        return false;
    }

    public static int ticksUntilUnfrozen(LivingEntity entity) {
        CompoundTag nbt;
        if (!(entity instanceof EntityIceDragon) && (nbt = FrozenProperties.getOrCreateFrozenData(entity)).m_128441_(FROZEN_TIME)) {
            return nbt.m_128451_(FROZEN_TIME);
        }
        return 0;
    }

    public static void setFrozenFor(LivingEntity entity, int duration) {
        if (!(entity instanceof EntityIceDragon)) {
            CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
            CompoundTag frozenData = FrozenProperties.getOrCreateFrozenData(entityData);
            if (!frozenData.m_128471_(FROZEN_BOOL)) {
                entity.m_5496_(SoundEvents.f_11986_, 1.0f, 1.0f);
            }
            frozenData.m_128405_(FROZEN_TIME, duration);
            frozenData.m_128379_(FROZEN_BOOL, true);
            entityData.m_128365_(FROZEN_DATA, (Tag)frozenData);
            FrozenProperties.updateData(entity, entityData);
        }
    }

    public static void updateData(LivingEntity entity) {
        FrozenProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundTag nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
        if (!entity.f_19853_.m_5776_()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.m_142049_()));
        }
    }

    public static void tickFrozenEntity(LivingEntity entity) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundTag frozenData = FrozenProperties.getOrCreateFrozenData(entityData);
        if (entity instanceof EntityIceDragon) {
            frozenData.m_128379_(FROZEN_BOOL, false);
        }
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (frozenData.m_128441_(FROZEN_TIME)) {
            int frozenTime = frozenData.m_128451_(FROZEN_TIME);
            if (entity.m_6060_()) {
                FrozenProperties.clearFrozenStatus(frozenData, entity, true);
                entity.m_20095_();
            } else if (entity.f_20919_ > 0) {
                FrozenProperties.clearFrozenStatus(frozenData, entity, false);
            } else if (frozenTime > 0) {
                frozenData.m_128405_(FROZEN_TIME, --frozenTime);
            } else {
                FrozenProperties.clearFrozenStatus(frozenData, entity, true);
            }
        }
        entityData.m_128365_(FROZEN_DATA, (Tag)frozenData);
        FrozenProperties.updateData(entity, entityData);
    }
}

