/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class BlockBreakExplosion
extends Explosion {
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final Mob exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<Player, Vec3> playerKnockbackMap = Maps.newHashMap();
    private final Vec3 position;
    private Explosion.BlockInteraction mode;

    public BlockBreakExplosion(Level world, Mob entity, double x, double y, double z, float size) {
        super(world, (Entity)entity, null, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.world = world;
        this.exploder = entity;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = new Vec3(x, y, z);
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)dropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        dropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void m_46061_() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.f_46441_.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.world.m_8055_(blockpos);
                        FluidState ifluidstate = this.world.m_6425_(blockpos);
                        if (!blockstate.m_60795_() || !ifluidstate.m_76178_()) {
                            float f2 = Math.max(blockstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this), ifluidstate.getExplosionResistance((BlockGetter)this.world, blockpos, (Explosion)this));
                            if (this.exploder != null) {
                                f2 = this.exploder.m_7077_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.m_7349_((Explosion)this, (BlockGetter)this.world, blockpos, blockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.size * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f3 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f3 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f3 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f3 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f3 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f3 + 1.0));
        List list = this.world.m_45933_((Entity)this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3 Vector3d = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || entity instanceof ItemEntity || !((d12 = Math.sqrt(entity.m_20238_(Vector3d)) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.x) * d5 + (d7 = entity.m_20188_() - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = BlockBreakExplosion.m_46064_((Vec3)Vector3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
            this.playerKnockbackMap.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        boolean flag;
        if (this.world.f_46443_) {
            this.world.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.f_46441_.nextFloat() - this.world.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.BlockInteraction.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.f_46441_);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.world.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.world, blockpos, (Explosion)this) && this.world instanceof ServerLevel) {
                    BlockEntity tileentity = blockstate.m_155947_() ? this.world.m_7702_(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.world).m_78977_(this.world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity).m_78984_(LootContextParams.f_81455_, (Object)this.exploder);
                    if (this.mode == Explosion.BlockInteraction.DESTROY) {
                        lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.size));
                    }
                    blockstate.m_60724_(lootcontext$builder).forEach(stack -> BlockBreakExplosion.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                }
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                this.world.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
    }

    @NotNull
    public Map<Player, Vec3> m_46078_() {
        return this.playerKnockbackMap;
    }

    public LivingEntity m_46079_() {
        return this.exploder;
    }

    public void m_46080_() {
        this.affectedBlockPositions.clear();
    }

    @NotNull
    public List<BlockPos> m_46081_() {
        return this.affectedBlockPositions;
    }

    @NotNull
    public Vec3 getPosition() {
        return this.position;
    }
}

