/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityChainTie;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ItemChain
extends Item {
    private final boolean sticky;

    public ItemChain(boolean sticky) {
        super(new Item.Properties().m_41491_(IceAndFire.TAB_ITEMS));
        this.sticky = sticky;
    }

    public static boolean attachToFence(Player player, Level worldIn, BlockPos fence) {
        EntityChainTie entityleashknot = EntityChainTie.getKnotForPosition(worldIn, fence);
        boolean flag = false;
        double d0 = 30.0;
        int i = fence.m_123341_();
        int j = fence.m_123342_();
        int k = fence.m_123343_();
        for (LivingEntity livingEntity : worldIn.m_45976_(LivingEntity.class, new AABB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            if (!ChainProperties.isChainedTo(livingEntity, (Entity)player)) continue;
            if (entityleashknot == null) {
                entityleashknot = EntityChainTie.createTie(worldIn, fence);
            }
            ChainProperties.removeChain(livingEntity, (Entity)player);
            ChainProperties.attachChain(livingEntity, (Entity)entityleashknot);
            flag = true;
        }
        return flag;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.chain.desc_0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.chain.desc_1").m_130940_(ChatFormatting.GRAY));
        if (this.sticky) {
            tooltip.add((Component)new TranslatableComponent("item.iceandfire.chain_sticky.desc_2").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)new TranslatableComponent("item.iceandfire.chain_sticky.desc_3").m_130940_(ChatFormatting.GREEN));
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player playerIn, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (ChainProperties.isChainedTo(target, (Entity)playerIn)) {
            return InteractionResult.SUCCESS;
        }
        if (this.sticky) {
            double d0 = 60.0;
            double i = playerIn.m_20185_();
            double j = playerIn.m_20186_();
            double k = playerIn.m_20189_();
            boolean flag = false;
            List nearbyEntities = playerIn.f_19853_.m_45976_(LivingEntity.class, new AABB(i - d0, j - d0, k - d0, i + d0, j + d0, k + d0));
            if (playerIn.m_6047_()) {
                ChainProperties.clearChainData(target);
                for (LivingEntity livingEntity : nearbyEntities) {
                    if (!ChainProperties.isChainedTo(livingEntity, (Entity)target)) continue;
                    ChainProperties.removeChain(livingEntity, (Entity)target);
                }
                return InteractionResult.SUCCESS;
            }
            for (LivingEntity livingEntity : nearbyEntities) {
                if (!ChainProperties.isChainedTo(livingEntity, (Entity)playerIn)) continue;
                ChainProperties.removeChain(target, (Entity)playerIn);
                ChainProperties.removeChain(livingEntity, (Entity)playerIn);
                ChainProperties.attachChain(livingEntity, (Entity)target);
                flag = true;
            }
            if (!flag) {
                ChainProperties.attachChain(target, (Entity)playerIn);
            }
        } else {
            ChainProperties.attachChain(target, (Entity)playerIn);
        }
        if (!playerIn.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        if (!(block instanceof WallBlock)) {
            return InteractionResult.PASS;
        }
        if (!context.m_43725_().f_46443_) {
            ItemChain.attachToFence(context.m_43723_(), context.m_43725_(), context.m_8083_());
        }
        return InteractionResult.SUCCESS;
    }
}

