/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.render.tile.RenderDeathWormGauntlet;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.NonNullLazy;
import org.jetbrains.annotations.NotNull;

public class ItemDeathwormGauntlet
extends Item {
    private boolean deathwormReceded = true;
    private boolean deathwormLaunched = false;
    private int specialDamage = 0;

    public ItemDeathwormGauntlet() {
        super(new Item.Properties().m_41503_(500).m_41491_(IceAndFire.TAB_ITEMS));
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            static final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> new RenderDeathWormGauntlet(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)renderer.get();
            }
        });
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 1;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (stack.m_41783_() != null) {
            if (this.deathwormReceded || this.deathwormLaunched) {
                return;
            }
            if (player instanceof Player) {
                if (stack.m_41783_().m_128451_("HolderID") != player.m_142049_()) {
                    stack.m_41783_().m_128405_("HolderID", player.m_142049_());
                }
                if (((Player)player).m_36335_().m_41521_((Item)this, 0.0f) == 0.0f) {
                    ((Player)player).m_36335_().m_41524_((Item)this, 10);
                    player.m_5496_(IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
                    this.deathwormReceded = false;
                    this.deathwormLaunched = true;
                }
            }
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity LivingEntity2, int timeLeft) {
        if (this.specialDamage > 0) {
            stack.m_41622_(this.specialDamage, LivingEntity2, player -> player.m_21190_(LivingEntity2.m_7655_()));
            this.specialDamage = 0;
        }
        if (stack.m_41783_().m_128451_("HolderID") != -1) {
            stack.m_41783_().m_128405_("HolderID", -1);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41656_(newStack);
    }

    public void m_6883_(ItemStack stack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        boolean hitMob = false;
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        } else {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            int tempLungeTicks = MiscProperties.getLungeTicks((LivingEntity)entity);
            if (this.deathwormReceded) {
                if (tempLungeTicks > 0) {
                    tempLungeTicks -= 4;
                }
                if (tempLungeTicks <= 0) {
                    tempLungeTicks = 0;
                    this.deathwormReceded = false;
                    this.deathwormLaunched = false;
                }
            } else if (this.deathwormLaunched && (tempLungeTicks = 4 + tempLungeTicks) > 20 && !this.deathwormReceded) {
                this.deathwormReceded = true;
            }
            if (MiscProperties.getLungeTicks((LivingEntity)entity) == 20 && entity instanceof Player) {
                Player player = (Player)entity;
                Vec3 Vector3d = player.m_20252_(1.0f).m_82541_();
                double range = 5.0;
                for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, new AABB(player.m_20185_() - range, player.m_20186_() - range, player.m_20189_() - range, player.m_20185_() + range, player.m_20186_() + range, player.m_20189_() + range))) {
                    if (livingEntity == entity) continue;
                    Vec3 Vector3d1 = new Vec3(livingEntity.m_20185_() - player.m_20185_(), livingEntity.m_20186_() - player.m_20186_(), livingEntity.m_20189_() - player.m_20189_());
                    double d0 = Vector3d1.m_82553_();
                    double d1 = Vector3d.m_82526_(Vector3d1 = Vector3d1.m_82541_());
                    boolean canSee = d1 > 1.0 - 0.5 / d0 && player.m_142582_((Entity)livingEntity);
                    if (!canSee) continue;
                    ++this.specialDamage;
                    livingEntity.m_6469_(DamageSource.m_19344_((Player)((Player)entity)), 3.0f);
                    livingEntity.m_147240_(0.5, livingEntity.m_20185_() - player.m_20185_(), livingEntity.m_20189_() - player.m_20189_());
                }
            }
            MiscProperties.setLungeTicks((LivingEntity)entity, tempLungeTicks);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.legendary_weapon.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.deathworm_gauntlet.desc_0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.deathworm_gauntlet.desc_1").m_130940_(ChatFormatting.GRAY));
    }
}

