/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.pathfinding.raycoms.MNode;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageSyncPath {
    public static Set<MNode> lastDebugNodesVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesNotVisited = new HashSet<MNode>();
    public static Set<MNode> lastDebugNodesPath = new HashSet<MNode>();

    public MessageSyncPath() {
    }

    public MessageSyncPath(Set<MNode> lastDebugNodesVisited, Set<MNode> lastDebugNodesNotVisited, Set<MNode> lastDebugNodesPath) {
        MessageSyncPath.lastDebugNodesVisited = lastDebugNodesVisited;
        MessageSyncPath.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
        MessageSyncPath.lastDebugNodesPath = lastDebugNodesPath;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(lastDebugNodesVisited.size());
        for (MNode MNode2 : lastDebugNodesVisited) {
            MNode2.serializeToBuf(buf);
        }
        buf.writeInt(lastDebugNodesNotVisited.size());
        for (MNode MNode2 : lastDebugNodesNotVisited) {
            MNode2.serializeToBuf(buf);
        }
        buf.writeInt(lastDebugNodesPath.size());
        for (MNode MNode2 : lastDebugNodesPath) {
            MNode2.serializeToBuf(buf);
        }
    }

    public static MessageSyncPath read(FriendlyByteBuf buf) {
        int i;
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesNotVisited.add(new MNode(buf));
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            lastDebugNodesPath.add(new MNode(buf));
        }
        return new MessageSyncPath();
    }

    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    public static class Handler {
        public static void handle(MessageSyncPath message, Supplier<NetworkEvent.Context> context) {
            Pathfinding.lastDebugNodesVisited = lastDebugNodesVisited;
            Pathfinding.lastDebugNodesNotVisited = lastDebugNodesNotVisited;
            Pathfinding.lastDebugNodesPath = lastDebugNodesPath;
            context.get().setPacketHandled(true);
        }
    }
}

