/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import com.github.alexthe666.iceandfire.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ChunkCache
implements LevelReader {
    protected int chunkX;
    protected int chunkZ;
    protected LevelChunk[][] chunkArray;
    protected boolean empty;
    protected Level world;

    public ChunkCache(Level worldIn, BlockPos posFromIn, BlockPos posToIn, int subIn) {
        this.world = worldIn;
        this.chunkX = posFromIn.m_123341_() - subIn >> 4;
        this.chunkZ = posFromIn.m_123343_() - subIn >> 4;
        int i = posToIn.m_123341_() + subIn >> 4;
        int j = posToIn.m_123343_() + subIn >> 4;
        this.chunkArray = new LevelChunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.empty = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                if (!ChunkCache.isEntityChunkLoaded((LevelAccessor)this.world, new ChunkPos(k, l))) continue;
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = (LevelChunk)worldIn.m_6522_(k, l, ChunkStatus.f_62326_, false);
            }
        }
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return ((ServerLevel)world).m_143340_(pos.m_45615_());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Nullable
    public BlockEntity m_7702_(@NotNull BlockPos pos) {
        return this.getTileEntity(pos, LevelChunk.EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity getTileEntity(BlockPos pos, LevelChunk.EntityCreationType createType) {
        int j;
        int i = (pos.m_123341_() >> 4) - this.chunkX;
        if (!this.withinBounds(i, j = (pos.m_123343_() >> 4) - this.chunkZ)) {
            return null;
        }
        return this.chunkArray[i][j].m_5685_(pos, createType);
    }

    @NotNull
    public BlockState m_8055_(BlockPos pos) {
        if (pos.m_123342_() >= 0 && pos.m_123342_() < 256) {
            LevelChunk chunk;
            int i = (pos.m_123341_() >> 4) - this.chunkX;
            int j = (pos.m_123343_() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.m_8055_(pos);
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    @NotNull
    public FluidState m_6425_(BlockPos pos) {
        if (pos.m_123342_() >= 0 && pos.m_123342_() < 256) {
            LevelChunk chunk;
            int i = (pos.m_123341_() >> 4) - this.chunkX;
            int j = (pos.m_123343_() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.m_6425_(pos);
            }
        }
        return Fluids.f_76191_.m_76145_();
    }

    @NotNull
    public Holder<Biome> m_204166_(@NotNull BlockPos pos) {
        Optional plains = ForgeRegistries.BIOMES.getHolder(Biomes.f_48202_);
        if (this.world.m_5776_() && plains.isPresent()) {
            return (Holder)plains.get();
        }
        return this.m_7062_().m_204214_(pos);
    }

    @NotNull
    public Holder<Biome> m_203675_(int x, int y, int z) {
        return null;
    }

    public boolean m_46859_(@NotNull BlockPos pos) {
        BlockState state = this.m_8055_(pos);
        return state.m_60795_();
    }

    @Nullable
    public ChunkAccess m_6522_(int x, int z, @NotNull ChunkStatus requiredStatus, boolean nonnull) {
        int i = x - this.chunkX;
        int j = z - this.chunkZ;
        if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length) {
            return this.chunkArray[i][j];
        }
        return null;
    }

    public boolean m_7232_(int chunkX, int chunkZ) {
        return false;
    }

    @NotNull
    public BlockPos m_5452_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Heightmap.Types heightmapType, @NotNull BlockPos pos) {
        return null;
    }

    public int m_6924_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Heightmap.Types heightmapType, int x, int z) {
        return 0;
    }

    public int m_7445_() {
        return 0;
    }

    @NotNull
    public BiomeManager m_7062_() {
        return null;
    }

    @NotNull
    public WorldBorder m_6857_() {
        return null;
    }

    public boolean m_5450_(@Nullable Entity entityIn, @NotNull VoxelShape shape) {
        return false;
    }

    @NotNull
    public List<VoxelShape> m_183134_(@Nullable Entity p_230318_1_, @NotNull AABB p_230318_2_) {
        return Collections.emptyList();
    }

    public int m_46852_(@NotNull BlockPos pos, @NotNull Direction direction) {
        return this.m_8055_(pos).m_60775_((BlockGetter)this, pos, direction);
    }

    public boolean m_5776_() {
        return false;
    }

    public int m_5736_() {
        return 0;
    }

    @NotNull
    public DimensionType m_6042_() {
        return null;
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }

    public float m_7717_(@NotNull Direction direction, boolean b) {
        return 0.0f;
    }

    @NotNull
    public LevelLightEngine m_5518_() {
        return null;
    }
}

