/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class IafWorldData
extends SavedData {
    private static final String IDENTIFIER = "iceandfire_general";
    protected BlockPos lastGeneratedDangerousStructure = BlockPos.f_121853_;
    private Level world;
    private int tickCounter;

    public IafWorldData() {
    }

    public IafWorldData(Level world) {
        this.world = world;
        this.m_77762_();
    }

    public IafWorldData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public static IafWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_142572_().m_129880_(world.m_46472_());
            DimensionDataStorage storage = overworld.m_8895_();
            IafWorldData data = (IafWorldData)storage.m_164861_(IafWorldData::new, IafWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public void setLastGeneratedDangerousStructure(BlockPos pos) {
        this.lastGeneratedDangerousStructure = pos;
        this.m_77762_();
    }

    public BlockPos getLastGeneratedDangerousStructure() {
        return this.lastGeneratedDangerousStructure;
    }

    public void tick() {
        ++this.tickCounter;
    }

    public IafWorldData load(CompoundTag nbt) {
        this.tickCounter = nbt.m_128451_("Tick");
        this.lastGeneratedDangerousStructure = new BlockPos(nbt.m_128451_("LastX"), nbt.m_128451_("LastY"), nbt.m_128451_("LastZ"));
        return this;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("Tick", this.tickCounter);
        compound.m_128405_("LastX", this.lastGeneratedDangerousStructure.m_123341_());
        compound.m_128405_("LastY", this.lastGeneratedDangerousStructure.m_123342_());
        compound.m_128405_("LastZ", this.lastGeneratedDangerousStructure.m_123343_());
        return compound;
    }
}

