/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenHydraCave
extends Feature<NoneFeatureConfiguration> {
    public static final ResourceLocation HYDRA_CHEST = new ResourceLocation("iceandfire", "chest/hydra_cave");
    protected static final ConfiguredFeature SWAMP_FEATURE = (ConfiguredFeature)TreeFeatures.f_195137_.m_203334_();
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenHydraCave(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        ChunkGenerator generator = context.m_159775_();
        if (!IafWorldRegistry.isDimensionListedForFeatures((ServerLevelAccessor)worldIn)) {
            return false;
        }
        if (!(IafConfig.generateHydraCaves && rand.nextInt(IafConfig.generateHydraChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, position))) {
            return false;
        }
        position = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
        int i1 = 8;
        int i2 = i1 - 2;
        int dist = 6;
        if (worldIn.m_46859_(position.m_142082_(i1 - dist, -3, -i1 + dist)) || worldIn.m_46859_(position.m_142082_(i1 - dist, -3, i1 - dist)) || worldIn.m_46859_(position.m_142082_(-i1 + dist, -3, -i1 + dist)) || worldIn.m_46859_(position.m_142082_(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.nextInt(2);
        int j = i1 + rand.nextInt(2);
        int k = 5 + ySize;
        int l = i1 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.m_123341_() >= position.m_123341_() - 2 + rand.nextInt(2) && blockpos.m_123341_() <= position.m_123341_() + 2 + rand.nextInt(2);
            boolean doorwayZ = blockpos.m_123343_() >= position.m_123343_() - 2 + rand.nextInt(2) && blockpos.m_123343_() <= position.m_123343_() + 2 + rand.nextInt(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.m_123342_() > position.m_123342_() || blockpos.m_123342_() > position.m_123342_() + k - (1 + rand.nextInt(2));
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
            if (!(worldIn.m_8055_(position).m_60734_() instanceof ChestBlock) && isNotInDoorway) {
                worldIn.m_7731_(blockpos, Blocks.f_50440_.m_49966_(), 3);
                if (worldIn.m_8055_(position.m_7495_()).m_60734_() == Blocks.f_50440_) {
                    worldIn.m_7731_(blockpos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
                }
                if (rand.nextInt(4) == 0) {
                    worldIn.m_7731_(blockpos.m_7494_(), Blocks.f_50034_.m_49966_(), 2);
                }
                if (rand.nextInt(9) == 0) {
                    SWAMP_FEATURE.m_65385_(worldIn, generator, rand, blockpos.m_7494_());
                }
            }
            if (blockpos.m_123342_() == position.m_123342_()) {
                worldIn.m_7731_(blockpos, Blocks.f_50440_.m_49966_(), 3);
            }
            if (blockpos.m_123342_() > position.m_123342_() - 1 || worldIn.m_8055_(blockpos).m_60815_()) continue;
            worldIn.m_7731_(blockpos, Blocks.f_50069_.m_49966_(), 3);
        }
        ySize = rand.nextInt(2);
        j = i2 + rand.nextInt(2);
        k = 4 + ySize;
        l = i2 + rand.nextInt(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f)) || blockpos.m_123342_() <= position.m_123342_() || worldIn.m_8055_(position).m_60734_() instanceof ChestBlock) continue;
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
        }
        for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k + 8, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
            BlockEntity tileentity1;
            if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f)) || blockpos.m_123342_() != position.m_123342_()) continue;
            if (rand.nextInt(30) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                worldIn.m_7731_(blockpos.m_6630_(1), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (!(worldIn.m_8055_(blockpos.m_6630_(1)).m_60734_() instanceof ChestBlock) || !((tileentity1 = worldIn.m_7702_(blockpos.m_6630_(1))) instanceof ChestBlockEntity)) continue;
                ((ChestBlockEntity)tileentity1).m_59626_(HYDRA_CHEST, rand.nextLong());
                continue;
            }
            if (rand.nextInt(45) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                worldIn.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rand.nextInt(15))), 2);
                tileentity1 = worldIn.m_7702_(blockpos.m_6630_(1));
                continue;
            }
            if (rand.nextInt(35) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                worldIn.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 2);
                for (Direction facing : Direction.values()) {
                    if (!(rand.nextFloat() < 0.3f) || facing == Direction.DOWN) continue;
                    worldIn.m_7731_(blockpos.m_7494_().m_142300_(facing), Blocks.f_50050_.m_49966_(), 2);
                }
                continue;
            }
            if (rand.nextInt(15) == 0 && this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) {
                worldIn.m_7731_(blockpos.m_7494_(), Blocks.f_50359_.m_49966_(), 2);
                continue;
            }
            if (rand.nextInt(15) != 0 || !this.isTouchingAir((LevelAccessor)worldIn, blockpos.m_7494_())) continue;
            worldIn.m_7731_(blockpos.m_7494_(), rand.nextBoolean() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_(), 2);
        }
        EntityHydra hydra = new EntityHydra((EntityType<EntityHydra>)((EntityType)IafEntityRegistry.HYDRA.get()), (Level)worldIn.m_6018_());
        hydra.setVariant(rand.nextInt(3));
        hydra.m_21446_(position, 15);
        hydra.m_19890_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 1.5, (double)position.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.m_7967_((Entity)hydra);
        return true;
    }

    private boolean isTouchingAir(LevelAccessor worldIn, BlockPos pos) {
        boolean isTouchingAir = true;
        for (Direction direction : HORIZONTALS) {
            if (worldIn.m_46859_(pos.m_142300_(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }
}

