/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WorldGenMyrmexDecoration {
    public static final ResourceLocation MYRMEX_GOLD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_loot_chest");
    public static final ResourceLocation DESERT_MYRMEX_FOOD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_desert_food_chest");
    public static final ResourceLocation JUNGLE_MYRMEX_FOOD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_jungle_food_chest");
    public static final ResourceLocation MYRMEX_TRASH_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_trash_chest");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public static void generateSkeleton(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            Direction direction = Direction.m_122407_((int)rand.nextInt(3));
            Direction.Axis oppositeAxis = direction.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            int maxRibHeight = rand.nextInt(2);
            for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
                BlockPos segment = blockpos.m_5484_(direction, spine);
                if (origin.m_123331_((Vec3i)segment) <= (double)(radius * radius)) {
                    worldIn.m_7731_(segment, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()), 2);
                }
                if (spine % 2 == 0) continue;
                BlockPos rightRib = segment.m_142300_(direction.m_122428_());
                BlockPos leftRib = segment.m_142300_(direction.m_122427_());
                if (origin.m_123331_((Vec3i)rightRib) <= (double)(radius * radius)) {
                    worldIn.m_7731_(rightRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                }
                if (origin.m_123331_((Vec3i)leftRib) <= (double)(radius * radius)) {
                    worldIn.m_7731_(leftRib, (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.m_123331_((Vec3i)rightRib.m_6630_(ribHeight).m_142300_(direction.m_122428_())) <= (double)(radius * radius)) {
                        worldIn.m_7731_(rightRib.m_6630_(ribHeight).m_142300_(direction.m_122428_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                    }
                    if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(ribHeight).m_142300_(direction.m_122427_())) <= (double)(radius * radius))) continue;
                    worldIn.m_7731_(leftRib.m_6630_(ribHeight).m_142300_(direction.m_122427_()), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y), 2);
                }
                if (origin.m_123331_((Vec3i)rightRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    worldIn.m_7731_(rightRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
                }
                if (!(origin.m_123331_((Vec3i)leftRib.m_6630_(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                worldIn.m_7731_(leftRib.m_6630_(maxRibHeight + 2), (BlockState)Blocks.f_50453_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)oppositeAxis), 2);
            }
        }
    }

    public static void generateLeaves(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand, boolean jungle) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            BlockState leaf = (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.TRUE);
            if (jungle) {
                leaf = (BlockState)Blocks.f_50053_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.TRUE);
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.m_121990_((BlockPos)blockpos.m_142082_(-j, -k, -l), (BlockPos)blockpos.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                    if (!(pos.m_123331_((Vec3i)blockpos) <= (double)(f * f)) || !worldIn.m_46859_(pos)) continue;
                    worldIn.m_7731_(pos, leaf, 4);
                }
                blockpos = blockpos.m_142082_(-(i1 + 1) + rand.nextInt(2 + i1 * 2), -rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generatePumpkins(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand, boolean jungle) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            worldIn.m_7731_(blockpos, jungle ? Blocks.f_50186_.m_49966_() : Blocks.f_50133_.m_49966_(), 2);
        }
    }

    public static void generateCocoon(LevelAccessor worldIn, BlockPos blockpos, Random rand, boolean jungle, ResourceLocation lootTable) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            worldIn.m_7731_(blockpos, jungle ? ((Block)IafBlockRegistry.JUNGLE_MYRMEX_COCOON.get()).m_49966_() : ((Block)IafBlockRegistry.DESERT_MYRMEX_COCOON.get()).m_49966_(), 3);
            if (worldIn.m_7702_(blockpos) != null && worldIn.m_7702_(blockpos) instanceof RandomizableContainerBlockEntity) {
                BlockEntity tileentity1 = worldIn.m_7702_(blockpos);
                ((RandomizableContainerBlockEntity)tileentity1).m_59626_(lootTable, rand.nextLong());
            }
        }
    }

    public static void generateMushrooms(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            worldIn.m_7731_(blockpos, rand.nextBoolean() ? Blocks.f_50072_.m_49966_() : Blocks.f_50073_.m_49966_(), 2);
        }
    }

    public static void generateGold(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        BlockState gold = ((Block)IafBlockRegistry.GOLD_PILE.get()).m_49966_();
        int choice = rand.nextInt(2);
        if (choice == 1) {
            gold = ((Block)IafBlockRegistry.SILVER_PILE.get()).m_49966_();
        } else if (choice == 2) {
            gold = ((Block)IafBlockRegistry.COPPER_PILE.get()).m_49966_();
        }
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            worldIn.m_7731_(blockpos, (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
            worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_142127_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_142128_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_142125_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.m_7731_(MyrmexHive.getGroundedPos(worldIn, blockpos.m_142126_()), (BlockState)gold.m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            if (rand.nextInt(3) == 0) {
                BlockEntity tileentity1;
                worldIn.m_7731_(blockpos.m_7494_(), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (worldIn.m_8055_(blockpos.m_7494_()).m_60734_() instanceof ChestBlock && (tileentity1 = worldIn.m_7702_(blockpos.m_7494_())) instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)tileentity1).m_59626_(MYRMEX_GOLD_CHEST, rand.nextLong());
                }
            }
        }
    }

    public static void generateTrashHeap(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)worldIn, blockpos.m_7495_(), Direction.UP)) {
            Block blob = Blocks.f_50493_;
            switch (rand.nextInt(3)) {
                case 0: {
                    blob = Blocks.f_50493_;
                    break;
                }
                case 1: {
                    blob = Blocks.f_49992_;
                    break;
                }
                case 2: {
                    blob = Blocks.f_50652_;
                    break;
                }
                case 3: {
                    blob = Blocks.f_49994_;
                }
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.m_121990_((BlockPos)blockpos.m_142082_(-j, -k, -l), (BlockPos)blockpos.m_142082_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                    if (!(pos.m_123331_((Vec3i)blockpos) <= (double)(f * f))) continue;
                    worldIn.m_7731_(pos, blob.m_49966_(), 4);
                }
                blockpos = blockpos.m_142082_(-(i1 + 1) + rand.nextInt(2 + i1 * 2), -rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generateTrashOre(LevelAccessor worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        Block current = worldIn.m_8055_(blockpos).m_60734_();
        if (origin.m_123331_((Vec3i)blockpos) <= (double)(radius * radius) && (current == Blocks.f_50493_ || current == Blocks.f_49992_ || current == Blocks.f_50652_ || current == Blocks.f_49994_)) {
            Block ore = Blocks.f_50173_;
            if (rand.nextInt(3) == 0) {
                Block block = ore = rand.nextBoolean() ? Blocks.f_49995_ : (Block)IafBlockRegistry.SILVER_ORE.get();
                if (rand.nextInt(2) == 0) {
                    ore = (Block)IafBlockRegistry.COPPER_ORE.get();
                }
            } else if (rand.nextInt(3) == 0) {
                ore = Blocks.f_50089_;
            } else if (rand.nextInt(2) == 0) {
                Block block = ore = rand.nextBoolean() ? Blocks.f_50264_ : (Block)IafBlockRegistry.SAPPHIRE_ORE.get();
                if (rand.nextInt(2) == 0) {
                    ore = (Block)IafBlockRegistry.AMYTHEST_ORE.get();
                }
            }
            worldIn.m_7731_(blockpos, ore.m_49966_(), 2);
        }
    }
}

