/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.structure;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.world.structure.Pool;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.jetbrains.annotations.NotNull;

public class DreadMausoleumStructure
extends StructureFeature<JigsawConfiguration> {
    public DreadMausoleumStructure() {
        super(JigsawConfiguration.f_67756_, DreadMausoleumStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public static JigsawConfiguration config(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        return new JigsawConfiguration(context.f_197360_().m_206191_(Registry.f_122884_).m_203538_(Pool.dread_pool), 5);
    }

    @NotNull
    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG) || !IafConfig.generateMausoleums) {
            return Optional.empty();
        }
        context = Pool.replaceContext(context, DreadMausoleumStructure.config(context));
        ChunkGenerator chunkGenerator = context.f_197352_();
        ChunkPos pos = context.f_197355_();
        LevelHeightAccessor height = context.f_197357_();
        Rotation rotation = Rotation.m_55956_((Random)ThreadLocalRandom.current());
        int xOffset = 5;
        int yOffset = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            xOffset = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            xOffset = -5;
            yOffset = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            yOffset = -5;
        }
        int x = pos.m_151390_();
        int z = pos.m_151393_();
        int y1 = chunkGenerator.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, height);
        int y2 = chunkGenerator.m_156179_(x, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, height);
        int y3 = chunkGenerator.m_156179_(x + xOffset, z, Heightmap.Types.WORLD_SURFACE_WG, height);
        int y4 = chunkGenerator.m_156179_(x + xOffset, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, height);
        int yMin = Math.min(Math.min(y1, y2), Math.min(y3, y4));
        BlockPos blockpos = pos.m_151394_(yMin + 1);
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public boolean canGenerate(@NotNull RegistryAccess p_197172_, @NotNull ChunkGenerator p_197173_, @NotNull BiomeSource p_197174_, @NotNull StructureManager p_197175_, long p_197176_, @NotNull ChunkPos p_197177_, @NotNull JigsawConfiguration p_197178_, @NotNull LevelHeightAccessor p_197179_, @NotNull Predicate<Holder<Biome>> p_197180_) {
        return super.m_197171_(p_197172_, p_197173_, p_197174_, p_197175_, p_197176_, p_197177_, (FeatureConfiguration)p_197178_, p_197179_, p_197180_);
    }
}

