/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.forge;

import com.google.gson.JsonObject;
import immersive_armors.Items;
import immersive_armors.config.Config;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class LootProvider {
    private static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"immersive_armors");
    private static final RegistryObject<ImmersiveArmorsLootModifier.Serializer> ARMOR_MODIFIER_SERIALIZER = GLM.register("armor_modifier_serializer", ImmersiveArmorsLootModifier.Serializer::new);

    public static void initialize() {
        if (Config.getInstance().lootChance > 0.0f) {
            GLM.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
    }

    public static class ImmersiveArmorsLootModifier
    extends LootModifier {
        public ImmersiveArmorsLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @NotNull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ResourceLocation id = context.getQueriedLootTableId();
            if (Items.lootLookup.containsKey(id.toString())) {
                for (Map.Entry<Supplier<Item>, Float> entry : Items.lootLookup.get(id.toString()).entrySet()) {
                    if (!(context.m_78952_().m_5822_().nextFloat() < entry.getValue().floatValue() * Config.getInstance().lootChance)) continue;
                    generatedLoot.add(new ItemStack((ItemLike)entry.getKey().get()));
                }
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<ImmersiveArmorsLootModifier> {
            private Serializer() {
            }

            public ImmersiveArmorsLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
                return new ImmersiveArmorsLootModifier(conditions);
            }

            public JsonObject write(ImmersiveArmorsLootModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class DataProvider
    extends GlobalLootModifierProvider {
        public DataProvider(DataGenerator gen, String modId) {
            super(gen, modId);
        }

        protected void start() {
            for (String s : Items.lootLookup.keySet()) {
                this.add("armor_modifier_serializer_" + s, (GlobalLootModifierSerializer)ARMOR_MODIFIER_SERIALIZER.get(), (IGlobalLootModifier)new ImmersiveArmorsLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(s)).m_6409_()}));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="immersive_armors", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlers {
        @SubscribeEvent
        public static void runData(GatherDataEvent event) {
            if (Config.getInstance().lootChance > 0.0f) {
                event.getGenerator().m_123914_((net.minecraft.data.DataProvider)new DataProvider(event.getGenerator(), "immersive_armors"));
            }
        }
    }
}

