/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blockentities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.infernalstudios.infernalexp.blocks.LuminousFungusBlock;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEBlockEntityTypes;

public class LuminousFungusBlockEntity
extends BlockEntity {
    public int lightTime = 0;

    public LuminousFungusBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntityTypes.LUMINOUS_FUNGUS.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, LuminousFungusBlockEntity blockEntity) {
        List nearbyEntities = world.m_45976_(Entity.class, new AABB(pos).m_82400_(InfernalExpansionConfig.Miscellaneous.LUMINOUS_FUNGUS_ACTIVATE_DISTANCE.getDouble()));
        Vec3 blockPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        nearbyEntities.removeIf(entity -> {
            Vec3 entityPos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            return world.m_45547_(new ClipContext(blockPos, entityPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.MISS;
        });
        boolean shouldLight = false;
        for (Entity entity2 : nearbyEntities) {
            if (entity2.f_19790_ != entity2.m_20185_() || entity2.f_19791_ != entity2.m_20186_() || entity2.f_19792_ != entity2.m_20189_()) {
                double velX = Math.abs(entity2.m_20185_() - entity2.f_19790_);
                double velY = Math.abs(entity2.m_20186_() - entity2.f_19791_);
                double velZ = Math.abs(entity2.m_20189_() - entity2.f_19792_);
                if (!(velX >= (double)0.003f) && !(velY >= (double)0.003f) && !(velZ >= (double)0.003f)) continue;
                shouldLight = true;
                break;
            }
            if (!(entity2.f_19787_ - entity2.f_19867_ > 0.0f) && !(entity2.m_20184_().m_82553_() > 0.1)) continue;
            shouldLight = true;
            break;
        }
        if (blockEntity.lightTime == 0) {
            world.m_46597_(blockEntity.f_58858_, (BlockState)state.m_61124_((Property)LuminousFungusBlock.LIT, (Comparable)Boolean.valueOf(shouldLight)));
        } else {
            --blockEntity.lightTime;
        }
        if (shouldLight) {
            blockEntity.lightTime = 60;
        }
    }
}

