/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import org.infernalstudios.infernalexp.entities.BlindsightEntity;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IETags;

public class DullthornsBlock
extends BushBlock
implements IForgeShearable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty TIP = BooleanProperty.m_61465_((String)"tip");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);

    public DullthornsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TIP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return true;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        return Arrays.asList(new ItemStack((ItemLike)IEItems.DULLTHORNS.get()));
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(IETags.Blocks.DULLTHORNS_GROUND);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        BlockPos blockpos = pos.m_7494_();
        if (worldIn.m_46859_(blockpos)) {
            int i = 1;
            while (worldIn.m_8055_(pos.m_6625_(i)).m_60713_((Block)this)) {
                ++i;
            }
            if (i < 9) {
                int j = (Integer)state.m_61143_((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)blockpos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.m_46597_(blockpos, this.m_49966_());
                        BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
                        worldIn.m_7731_(pos, blockstate, 4);
                        blockstate.m_60690_((Level)worldIn, blockpos, (Block)this, pos, false);
                    } else {
                        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public boolean bonemealGrow(BlockState state, Level worldIn, BlockPos pos) {
        BlockPos posUp = pos.m_7494_();
        if (worldIn.m_46859_(posUp)) {
            worldIn.m_46597_(posUp, this.m_49966_());
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            worldIn.m_7731_(pos, blockstate, 4);
            blockstate.m_60690_(worldIn, posUp, (Block)this, pos, false);
            return true;
        }
        if (worldIn.m_8055_(posUp).m_60734_() == IEBlocks.DULLTHORNS.get()) {
            return ((DullthornsBlock)worldIn.m_8055_(posUp).m_60734_()).bonemealGrow(state, worldIn, posUp);
        }
        return false;
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.m_5776_()) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                if (entityIn.m_6084_() && !(entityIn instanceof BlindsightEntity)) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 200, 0, true, true));
                }
            }
            entityIn.m_6469_(DamageSource.f_19314_, 1.0f);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState aboveBlockState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        boolean aboveIsDullthorns = aboveBlockState.m_60713_((Block)IEBlocks.DULLTHORNS.get());
        if (aboveIsDullthorns) {
            return this.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState aboveBlockState = worldIn.m_8055_(currentPos.m_7494_());
        boolean aboveIsDullthorns = aboveBlockState.m_60713_((Block)IEBlocks.DULLTHORNS.get());
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (!aboveIsDullthorns && !((Boolean)stateIn.m_61143_((Property)TIP)).booleanValue()) {
            return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)stateIn.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(true));
        }
        if (aboveIsDullthorns && ((Boolean)stateIn.m_61143_((Property)TIP)).booleanValue()) {
            return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)stateIn.m_61124_((Property)TIP, (Comparable)Boolean.valueOf(false));
        }
        return stateIn;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        return SHAPE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
        builder.m_61104_(new Property[]{TIP});
    }
}

