/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.infernalstudios.infernalexp.blockentities.LuminousFungusBlockEntity;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEBlockEntityTypes;
import org.infernalstudios.infernalexp.init.IEConfiguredFeatures;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IETags;

public class LuminousFungusBlock
extends HorizontalBushBlock
implements BonemealableBlock,
EntityBlock,
BlockEntityTicker<LuminousFungusBlockEntity> {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape FLOOR_SHAPE = LuminousFungusBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = LuminousFungusBlock.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public LuminousFungusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isValidGround(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(IETags.Blocks.LUMINOUS_FUNGUS_BASE_BLOCKS);
    }

    public boolean canAttachToSurface(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_142300_(direction);
        return this.isValidGround(reader.m_8055_(blockpos), (BlockGetter)reader, blockpos);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !((AttachFace)state.m_61143_((Property)f_53179_)).equals((Object)AttachFace.WALL) && this.canAttachToSurface(worldIn, pos, LuminousFungusBlock.m_53200_((BlockState)state).m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return FLOOR_SHAPE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
            }
        }
        return CEILING_SHAPE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.m_5776_() && entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (entityIn.m_6084_() && InfernalExpansionConfig.Miscellaneous.LUMINOUS_FUNGUS_GIVES_EFFECT.getBool()) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)IEEffects.LUMINOUS.get(), 120, 0, true, true));
            }
        }
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builderIn) {
        builderIn.m_61104_(new Property[]{f_54117_, f_53179_, LIT});
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Block block = ((HugeFungusConfiguration)((ConfiguredFeature)IEConfiguredFeatures.DULLTHORN_TREE_PLANTED.m_203334_()).f_65378_()).f_65897_.m_60734_();
        Block block1 = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        return block1 == block;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        ((ConfiguredFeature)IEConfiguredFeatures.DULLTHORN_TREE_PLANTED.m_203334_()).m_65385_((WorldGenLevel)worldIn, worldIn.m_7726_().m_8481_(), rand, pos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LuminousFungusBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (!world.m_5776_()) {
            return LuminousFungusBlock.createTickerHelper(type, (BlockEntityType)IEBlockEntityTypes.LUMINOUS_FUNGUS.get(), LuminousFungusBlockEntity::tick);
        }
        return null;
    }

    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type, BlockEntityType<E> correctType, BlockEntityTicker<? super E> ticker) {
        return type == correctType ? ticker : null;
    }

    public void tick(Level p_155253_, BlockPos p_155254_, BlockState p_155255_, LuminousFungusBlockEntity p_155256_) {
    }
}

